/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.handler;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.upload.CrashlyticsController;
import com.ainirobot.base.upload.handler.AHandler;
import com.ainirobot.base.upload.writer.EventWriterFactory;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.CLSUUID;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiHandler
extends AHandler {
    private final List<JSONObject> mApiJsonObjects = new ArrayList<JSONObject>();
    private long apiRecordStartTime;
    public static final int MAX_API_REPORT_INTERVAL = 300000;

    public void handle(int type, String action, String params, boolean forceSave, Bundle extras) {
        this.writeToLog(type, action, params, forceSave, extras);
    }

    @Override
    public boolean acceptFile(String filename) {
        return filename.length() == 35 + ".api".length() && filename.endsWith(".api");
    }

    @Override
    public boolean acceptCacheFile(String filename) {
        return filename.length() == 35 + ".api_cache".length() && filename.endsWith(".api_cache");
    }

    @Override
    protected int maxSessionCount() {
        return 20;
    }

    public ApiHandler(Context context, BackgroundWorker backgroundWorker, File filesDir, HttpRequestFactory httpRequestFactory, CrashlyticsController controller) {
        super(context, backgroundWorker, filesDir, httpRequestFactory, controller);
    }

    @Override
    protected void doOpenSession() {
        super.doOpenSession();
        this.apiRecordStartTime = System.currentTimeMillis();
    }

    private void writeToLog(final int type, final String action, final String params, final boolean forceSave, final Bundle extras) {
        final long timestamp = System.currentTimeMillis();
        this.mBackgroundWorker.submit(new Callable<Void>(){

            private String getUUID() {
                String uuid = UUID.randomUUID().toString();
                if (uuid.length() >= 13) {
                    return uuid.substring(0, 13);
                }
                return uuid;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void add() {
                List list = ApiHandler.this.mApiJsonObjects;
                synchronized (list) {
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("id", (Object)this.getUUID());
                        jsonObject.put("t", timestamp);
                        jsonObject.put("type", type);
                        jsonObject.put("actionId", (Object)action);
                        jsonObject.put("params", (Object)params);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    ApiHandler.this.mApiJsonObjects.add(jsonObject);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void clear(List<JSONObject> jsonObjectList) {
                List list = ApiHandler.this.mApiJsonObjects;
                synchronized (list) {
                    ApiHandler.this.mApiJsonObjects.removeAll(jsonObjectList);
                    ApiHandler.this.apiRecordStartTime = System.currentTimeMillis();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List<JSONObject> get() {
                List list = ApiHandler.this.mApiJsonObjects;
                synchronized (list) {
                    return new ArrayList<JSONObject>(ApiHandler.this.mApiJsonObjects);
                }
            }

            @Override
            public Void call() throws Exception {
                if (!forceSave) {
                    this.add();
                }
                if (Constants.BUILD_TYPE_UNIT_TEST || forceSave || ApiHandler.this.checkSaveApiCondition(timestamp)) {
                    try {
                        ApiHandler.this.doOpenSession();
                        String currentSessionId = ApiHandler.this.getCurrentSessionId();
                        if (currentSessionId == null) {
                            Logger.w("Tried to write a api while no session was open.", new Object[]{null});
                        }
                        String tag = ".api_temp";
                        final String fileName = forceSave ? currentSessionId : new CLSUUID().toString();
                        ApiHandler.this.writeFile(fileName, ".api_temp", new AHandler.FileOutputStreamWriteAction(){

                            @Override
                            public void writeTo(FileOutputStream fileOutputStream) throws Exception {
                                List jsonObjectList = this.get();
                                EventWriterFactory.createApiWriter(ApiHandler.this.sessionId, jsonObjectList, extras).write(fileOutputStream);
                                File tempFile = new File(ApiHandler.this.mFilesDir, fileName + ".api_temp");
                                File dstFile = new File(ApiHandler.this.mFilesDir, fileName + ".api");
                                FileUtils.renameTempFile(tempFile, dstFile);
                                this.clear(jsonObjectList);
                            }
                        });
                    }
                    catch (Exception e) {
                        Logger.e("An error occurred in the api call logger", new Object[0]);
                    }
                    ApiHandler.this.sendSessionReport();
                }
                return null;
            }
        });
    }

    private boolean checkSaveApiCondition(long timestamp) {
        return this.mApiJsonObjects.size() >= 20 || timestamp - this.apiRecordStartTime >= 300000L;
    }
}

