/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.handler;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.contentprovider.ErrorInfo;
import com.ainirobot.base.contentprovider.ErrorInfoResolver;
import com.ainirobot.base.cos.CosManager;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.upload.CrashlyticsController;
import com.ainirobot.base.upload.handler.AHandler;
import com.ainirobot.base.upload.writer.EventWriterFactory;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.Callable;

public class AnrHandler
extends AHandler {
    @Override
    public boolean acceptFile(String filename) {
        return filename.length() == 35 + ".anr".length() && filename.endsWith(".anr");
    }

    @Override
    public boolean acceptCacheFile(String filename) {
        return filename.length() == 35 + ".anr_cache".length() && filename.endsWith(".anr_cache");
    }

    @Override
    protected int maxSessionCount() {
        return 20;
    }

    public AnrHandler(Context context, BackgroundWorker backgroundWorker, File filesDir, HttpRequestFactory httpRequestFactory, CrashlyticsController controller) {
        super(context, backgroundWorker, filesDir, httpRequestFactory, controller);
    }

    public void handle(final String path, final String wholePath, final String reason, final Bundle extras) {
        this.mBackgroundWorker.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                CrashlyticsController crashlyticsController = AnrHandler.this.mController;
                synchronized (crashlyticsController) {
                    AnrHandler.this.doOpenSession();
                    AnrHandler.this.writeToANR(path, wholePath, reason, extras);
                    AnrHandler.this.sendSessionReport();
                    AnrHandler.this.mController.submitAllReports(0.0f);
                }
                return null;
            }
        });
    }

    synchronized void writeToANR(final String path, String wholePath, final String reason, final Bundle extras) {
        try {
            final String currentSessionId = this.getCurrentSessionId();
            if (currentSessionId == null) {
                Logger.w("Tried to write a anr while no session was open.", new Object[]{null});
            }
            String tag = ".anr.public";
            File dstFile = new File(this.mContext.getFilesDir(), this.sessionId + "_anr_whole.txt");
            final String cosAnrUrl = this.getCosUrl(dstFile.getAbsolutePath());
            this.writeFile(currentSessionId, tag, new AHandler.FileOutputStreamWriteAction(){

                @Override
                public void writeTo(FileOutputStream fileOutputStream) throws Exception {
                    EventWriterFactory.createAnrWriter(currentSessionId, path, cosAnrUrl, reason, AnrHandler.this.mContext, extras).write(fileOutputStream);
                    Logger.d("ANR end write file", new Object[0]);
                }
            });
            this.insertToDB(extras);
        }
        catch (Exception e) {
            Logger.e("An error occurred in the anr logger", e);
        }
    }

    String getCosUrl(String path) {
        return CosManager.getBucketPath(path);
    }

    void insertToDB(Bundle extras) {
        long cTime = extras.getLong("key_ctime");
        String shortMsg = extras.getString("key_short_msg");
        String fileName = extras.getString("key_orion_file_name");
        ErrorInfo info = new ErrorInfo();
        info.type = 1;
        info.fileName = fileName;
        info.shortMsg = shortMsg;
        info.timeStamp = cTime;
        ErrorInfoResolver.getInstance().insert(info);
    }
}

