/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.handler;

import android.content.Context;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.report.ANRReport;
import com.ainirobot.base.report.CompositeCreateReportSpiCall;
import com.ainirobot.base.report.CreateReportSpiCall;
import com.ainirobot.base.report.DefaultCreateReportSpiCall;
import com.ainirobot.base.report.Report;
import com.ainirobot.base.report.ReportUploader;
import com.ainirobot.base.report.SessionReport;
import com.ainirobot.base.upload.CrashlyticsController;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.CLSUUID;
import com.ainirobot.base.util.CommonUtils;
import com.ainirobot.base.util.LocalUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public abstract class AHandler {
    protected String sessionId = null;
    protected final BackgroundWorker mBackgroundWorker;
    protected final File mFilesDir;
    protected final HttpRequestFactory mHttpRequestFactory;
    protected final Context mContext;
    protected CrashlyticsController mController;
    protected File mFile;
    private final FilenameFilter SESSION_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return AHandler.this.acceptFile(filename);
        }
    };
    private final FilenameFilter SESSION_CACHE_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return AHandler.this.acceptCacheFile(filename);
        }
    };
    private final FilenameFilter SESSION_ALL_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return AHandler.this.acceptCacheFile(filename) || AHandler.this.acceptFile(filename);
        }
    };
    static final Comparator<File> SMALLEST_FILE_NAME_FIRST = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return file1.getName().compareTo(file2.getName());
        }
    };

    protected abstract boolean acceptFile(String var1);

    protected abstract boolean acceptCacheFile(String var1);

    protected abstract int maxSessionCount();

    public AHandler(Context context, BackgroundWorker backgroundWorker, File filesDir, HttpRequestFactory httpRequestFactory, CrashlyticsController controller) {
        this.mBackgroundWorker = backgroundWorker;
        this.mFilesDir = filesDir;
        this.mHttpRequestFactory = httpRequestFactory;
        this.mContext = context;
        this.mController = controller;
    }

    protected String getCurrentSessionId() {
        return this.sessionId;
    }

    protected void doOpenSession() {
        this.sessionId = new CLSUUID().toString();
        Logger.d("CrashlyticsCore", "Opening a new session with ID " + this.sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String sessionId, String tag, FileOutputStreamWriteAction writeAction) throws Exception {
        FileOutputStream fos = null;
        try {
            this.mFile = new File(this.mFilesDir, sessionId + tag);
            fos = new FileOutputStream(this.mFile);
            writeAction.writeTo(fos);
        }
        catch (Throwable throwable) {
            CommonUtils.closeOrLog(fos, "Failed to close " + tag + " file.");
            throw throwable;
        }
        CommonUtils.closeOrLog(fos, "Failed to close " + tag + " file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String sessionId, int type, String tag, FileOutputStreamWriteAction writeAction) throws Exception {
        FileOutputStream fos = null;
        try {
            this.mFile = new File(this.mFilesDir, this.getFileName(sessionId, type, tag));
            fos = new FileOutputStream(this.mFile);
            writeAction.writeTo(fos);
        }
        catch (Throwable throwable) {
            CommonUtils.closeOrLog(fos, "Failed to close " + tag + " file.");
            throw throwable;
        }
        CommonUtils.closeOrLog(fos, "Failed to close " + tag + " file.");
    }

    protected String getFileName(String sessionId, int type, String tag) {
        return sessionId + "_" + type + tag;
    }

    protected void sendSessionReport() {
        if (this.mFile.getPath().contains(".anr")) {
            this.trimAnrSessionFiles();
        } else {
            this.trimSessionFiles();
        }
        if (this.mFile == null || !this.mFile.exists()) {
            return;
        }
        if (!this.canSendReport()) {
            return;
        }
        Context context = this.mContext;
        String sessionReportUrl = Constants.getJavaReportsUrl();
        String anrSessionReportUrl = Constants.getAnrReportsUrl();
        CreateReportSpiCall call = this.getCreateReportSpiCall(sessionReportUrl, anrSessionReportUrl);
        ReportUploader reportUploader = new ReportUploader(call);
        Report report = null;
        if (this.mFile.getPath().contains(".anr")) {
            String path = this.mFile.getPath().replace(".public", "");
            File file = new File(path);
            if (file.exists()) {
                report = new ANRReport(this.mFilesDir, file);
            }
        } else {
            report = new SessionReport(this.mFile);
        }
        if (CommonUtils.canTryConnection(context) && report != null) {
            Logger.d("CrashlyticsCore", "Attempting to send crash report at time of crash...");
            reportUploader.forceUpload(report);
        }
    }

    public File[] listCompleteSessionFiles() {
        LinkedList completeSessionFiles = new LinkedList();
        Collections.addAll(completeSessionFiles, this.listFilesMatching(this.mFilesDir, this.SESSION_FILE_FILTER));
        return completeSessionFiles.toArray(new File[completeSessionFiles.size()]);
    }

    public File[] listCacheCompleteSessionFiles() {
        LinkedList completeSessionFiles = new LinkedList();
        Collections.addAll(completeSessionFiles, this.listFilesMatching(this.mFilesDir, this.SESSION_CACHE_FILE_FILTER));
        return completeSessionFiles.toArray(new File[completeSessionFiles.size()]);
    }

    private File[] listFilesMatching(File directory, FilenameFilter filter) {
        return this.ensureFileArrayNotNull(directory.listFiles(filter));
    }

    private File[] ensureFileArrayNotNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    private CreateReportSpiCall getCreateReportSpiCall(String reportsUrl, String anrReportsUrl) {
        DefaultCreateReportSpiCall defaultCreateReportSpiCall = new DefaultCreateReportSpiCall(reportsUrl, this.mHttpRequestFactory);
        DefaultCreateReportSpiCall anrCreateReportSpiCall = new DefaultCreateReportSpiCall(anrReportsUrl, this.mHttpRequestFactory);
        return new CompositeCreateReportSpiCall(defaultCreateReportSpiCall, anrCreateReportSpiCall);
    }

    private boolean canSendReport() {
        return !"0".equals(LocalUtils.getAutoCollectCrashLog(this.mContext));
    }

    protected void trimSessionFiles() {
        CommonUtils.capFileCount(this.mFilesDir, this.SESSION_ALL_FILE_FILTER, this.maxSessionCount(), SMALLEST_FILE_NAME_FIRST);
    }

    protected void trimAnrSessionFiles() {
        CommonUtils.capAnrFileCount(this.mFilesDir, this.SESSION_ALL_FILE_FILTER, this.maxSessionCount(), SMALLEST_FILE_NAME_FIRST);
    }

    public static interface FileOutputStreamWriteAction {
        public void writeTo(FileOutputStream var1) throws Exception;
    }
}

