/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.data;

import com.ainirobot.base.upload.data.StackTraceTrimmingStrategy;
import java.util.HashMap;

public class RemoveRepeatsStrategy
implements StackTraceTrimmingStrategy {
    private final int maxRepetitions;

    public RemoveRepeatsStrategy() {
        this(1);
    }

    public RemoveRepeatsStrategy(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    @Override
    public StackTraceElement[] getTrimmedStackTrace(StackTraceElement[] stacktrace) {
        StackTraceElement[] trimmed = RemoveRepeatsStrategy.trimRepeats(stacktrace, this.maxRepetitions);
        return trimmed.length < stacktrace.length ? trimmed : stacktrace;
    }

    private static StackTraceElement[] trimRepeats(StackTraceElement[] stacktrace, int maxRepetitions) {
        HashMap<StackTraceElement, Integer> mostRecentIndices = new HashMap<StackTraceElement, Integer>();
        StackTraceElement[] buffer = new StackTraceElement[stacktrace.length];
        int trimmedLength = 0;
        int numRepeats = 1;
        for (int i = 0; i < stacktrace.length; ++i) {
            int currentIndex = i;
            StackTraceElement currentFrame = stacktrace[i];
            Integer previousIndex = (Integer)mostRecentIndices.get(currentFrame);
            if (previousIndex == null || !RemoveRepeatsStrategy.isRepeatingSequence(stacktrace, previousIndex, i)) {
                numRepeats = 1;
                buffer[trimmedLength] = stacktrace[i];
                ++trimmedLength;
            } else {
                int windowSize = i - previousIndex;
                if (numRepeats < maxRepetitions) {
                    System.arraycopy(stacktrace, i, buffer, trimmedLength, windowSize);
                    trimmedLength += windowSize;
                    ++numRepeats;
                }
                i += windowSize - 1;
            }
            mostRecentIndices.put(currentFrame, currentIndex);
        }
        StackTraceElement[] trimmed = new StackTraceElement[trimmedLength];
        System.arraycopy(buffer, 0, trimmed, 0, trimmed.length);
        return trimmed;
    }

    private static boolean isRepeatingSequence(StackTraceElement[] stacktrace, int prevIndex, int currentIndex) {
        int windowSize = currentIndex - prevIndex;
        if (currentIndex + windowSize > stacktrace.length) {
            return false;
        }
        for (int i = 0; i < windowSize; ++i) {
            if (stacktrace[prevIndex + i].equals(stacktrace[currentIndex + i])) continue;
            return false;
        }
        return true;
    }
}

