/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload.data;

import com.ainirobot.base.upload.data.MiddleOutStrategy;
import com.ainirobot.base.upload.data.StackTraceTrimmingStrategy;

public class MiddleOutFallbackStrategy
implements StackTraceTrimmingStrategy {
    private final int maximumStackSize;
    private final MiddleOutStrategy middleOutStrategy;
    private final StackTraceTrimmingStrategy[] trimmingStrategies;

    public MiddleOutFallbackStrategy(int maximumStackSize, StackTraceTrimmingStrategy ... strategies) {
        this.maximumStackSize = maximumStackSize;
        this.trimmingStrategies = strategies;
        this.middleOutStrategy = new MiddleOutStrategy(maximumStackSize);
    }

    @Override
    public StackTraceElement[] getTrimmedStackTrace(StackTraceElement[] stacktrace) {
        if (stacktrace.length <= this.maximumStackSize) {
            return stacktrace;
        }
        StackTraceElement[] trimmed = stacktrace;
        for (StackTraceTrimmingStrategy strategy : this.trimmingStrategies) {
            if (trimmed.length <= this.maximumStackSize) break;
            trimmed = strategy.getTrimmedStackTrace(stacktrace);
        }
        if (trimmed.length > this.maximumStackSize) {
            trimmed = this.middleOutStrategy.getTrimmedStackTrace(trimmed);
        }
        return trimmed;
    }
}

