/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import java.io.File;

public class OrionContext
extends ContextWrapper {
    private final String componentName;
    private final String componentPath;

    public OrionContext(Context base, String componentName, String componentPath) {
        super(base);
        this.componentName = componentName;
        this.componentPath = componentPath;
    }

    public File getDatabasePath(String name) {
        File dir = new File(super.getDatabasePath(name).getParentFile(), this.componentPath);
        dir.mkdirs();
        return new File(dir, name);
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), (SQLiteDatabase.CursorFactory)factory);
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openOrCreateDatabase((String)this.getDatabasePath(name).getPath(), (SQLiteDatabase.CursorFactory)factory, (DatabaseErrorHandler)errorHandler);
    }

    public File getFilesDir() {
        return new File(super.getFilesDir(), this.componentPath);
    }

    public File getExternalFilesDir(String type) {
        return new File(super.getExternalFilesDir(type), this.componentPath);
    }

    public File getCacheDir() {
        return new File(super.getCacheDir(), this.componentPath);
    }

    public File getExternalCacheDir() {
        return new File(super.getExternalCacheDir(), this.componentPath);
    }

    public SharedPreferences getSharedPreferences(String name, int mode) {
        return super.getSharedPreferences(this.componentName + ":" + name, mode);
    }
}

