/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.ainirobot.base.network.DefaultHttpRequestFactory;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.upload.CrashlyticsController;
import com.ainirobot.base.upload.OrionContext;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.ExecutorUtils;
import com.ainirobot.base.util.FileStoreImpl;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.SystemUtils;
import java.io.File;
import java.util.concurrent.ExecutorService;

public class CrashlyticsCore {
    private Context context;
    public static final String TAG = "CrashlyticsCore";
    public static final String ROOT_DIR = ".OrionHawk";
    private CrashlyticsController controller;
    private BackgroundWorker backgroundWorker;
    private HttpRequestFactory httpRequestFactory;

    public CrashlyticsCore(Context context) {
        this(context, ExecutorUtils.buildSingleThreadExecutorService());
    }

    CrashlyticsCore(Context context, ExecutorService crashHandlerExcutor) {
        this.context = new OrionContext(context, this.getIdentifier(), this.getPath());
        this.backgroundWorker = new BackgroundWorker(crashHandlerExcutor);
    }

    public void init() {
        FileStoreImpl fileStore = new FileStoreImpl(this.getContext(), this.getPath());
        this.httpRequestFactory = new DefaultHttpRequestFactory();
        this.controller = new CrashlyticsController(this, this.backgroundWorker, this.httpRequestFactory, fileStore);
        this.controller.updateAppInfo();
        this.controller.cleanInvalidTempFiles();
    }

    public Context getContext() {
        return this.context;
    }

    public String getPath() {
        return ROOT_DIR + File.separator + this.getIdentifier();
    }

    public String getIdentifier() {
        return "com.cmcm.orionbase.crashlytics-core";
    }

    public void logCrash(Thread thread, Throwable throwable, Bundle extras) {
        this.controller.logCrash(thread, throwable, extras);
        Logger.d("logCrash", throwable);
        Log.e((String)"OrionBase", (String)("memeory info: \n" + SystemUtils.getMemInfo()));
    }

    public void logNativeCrash(Thread thread, Bundle extras) {
        this.controller.logNativeCrash(thread, extras);
        Logger.d("logNativeCrash", extras);
    }

    public void logApi(int type, String action, String msg, Bundle extras) {
        this.controller.logApi(type, action, msg, extras);
        Logger.d("" + action + ":" + msg, new Object[0]);
    }

    public void logAnr(String path, String wholePath, String reason, Bundle extras) {
        this.controller.logAnr(path, wholePath, reason, extras);
    }

    public void logPerformance(String performanceData, int type, boolean forceReport, Bundle extras) {
        this.controller.logPerformance(performanceData, type, forceReport, extras);
    }
}

