/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.upload;

import android.content.Context;
import android.os.Bundle;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.report.CompositeCreateReportSpiCall;
import com.ainirobot.base.report.CreateReportSpiCall;
import com.ainirobot.base.report.DefaultCreateReportSpiCall;
import com.ainirobot.base.report.ReportUploader;
import com.ainirobot.base.upload.CrashlyticsCore;
import com.ainirobot.base.upload.handler.AnrHandler;
import com.ainirobot.base.upload.handler.ApiHandler;
import com.ainirobot.base.upload.handler.JavaCrashHandler;
import com.ainirobot.base.upload.handler.NativeCrashHandler;
import com.ainirobot.base.upload.handler.PerformanceHandler;
import com.ainirobot.base.upload.handler.WholeAnrHandler;
import com.ainirobot.base.upload.report.SettingsRequest;
import com.ainirobot.base.upload.report.UpdateAppSpiCall;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.FileStore;
import com.ainirobot.base.util.LocalUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CrashlyticsController {
    private final CrashlyticsCore core;
    private final BackgroundWorker backgroundWorker;
    private final FileStore fileStore;
    private final HttpRequestFactory httpRequestFactory;
    private final ReportUploader.ReportFilesProvider reportFilesProvider;
    private JavaCrashHandler mJavaCrashHandler;
    private NativeCrashHandler mNativeCrashHandler;
    private AnrHandler mAnrHandler;
    private WholeAnrHandler mWholeAnrHandler;
    private ApiHandler mApiHandler;
    private PerformanceHandler mPerformanceHandler;
    private ReportUploader mReportUploader;
    private static final Pattern SESSION_FILE_PATTERN = Pattern.compile("([\\d|A-Z|a-z]{12}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{4}\\-[\\d|A-Z|a-z]{12}).+");

    CrashlyticsController(CrashlyticsCore core, BackgroundWorker backgroundWorker, HttpRequestFactory httpRequestFactory, FileStore fileStore) {
        this.core = core;
        this.backgroundWorker = backgroundWorker;
        this.httpRequestFactory = httpRequestFactory;
        this.reportFilesProvider = new ReportUploaderFilesProvider();
        this.fileStore = fileStore;
        this.mJavaCrashHandler = new JavaCrashHandler(core.getContext(), backgroundWorker, fileStore.getFilesDir(), httpRequestFactory, this);
        this.mNativeCrashHandler = new NativeCrashHandler(core.getContext(), backgroundWorker, fileStore.getFilesDir(), httpRequestFactory, this);
        this.mApiHandler = new ApiHandler(core.getContext(), backgroundWorker, fileStore.getFilesDir(), httpRequestFactory, this);
        this.mAnrHandler = new AnrHandler(core.getContext(), backgroundWorker, fileStore.getFilesDir(), httpRequestFactory, this);
        this.mWholeAnrHandler = new WholeAnrHandler(core.getContext(), backgroundWorker, fileStore.getFilesDir(), httpRequestFactory, this);
        this.mPerformanceHandler = new PerformanceHandler(core.getContext(), backgroundWorker, fileStore.getFilesDir(), httpRequestFactory, this);
    }

    public void logCrash(Thread thread, Throwable throwable, Bundle extras) {
        this.mJavaCrashHandler.handle(thread, throwable, extras);
    }

    public void logNativeCrash(Thread thread, Bundle extras) {
        this.mNativeCrashHandler.handle(thread, extras);
    }

    public void logApi(int type, String action, String params, Bundle extras) {
        this.mApiHandler.handle(type, action, params, false, extras);
    }

    public void logAnr(String path, String wholePath, String reason, Bundle extras) {
        this.mAnrHandler.handle(path, wholePath, reason, extras);
    }

    public void logPerformance(String performanceData, int type, boolean forceReport, Bundle extras) {
        this.mPerformanceHandler.handle(performanceData, type, forceReport, extras);
    }

    private File[] listCompleteSessionFiles() {
        File[] apiFiles = this.mApiHandler.listCompleteSessionFiles();
        File[] anrFiles = this.mAnrHandler.listCompleteSessionFiles();
        File[] wholeAnrFiles = this.mWholeAnrHandler.listCompleteSessionFiles();
        File[] javaCrashFiles = this.mJavaCrashHandler.listCompleteSessionFiles();
        File[] nativeCrasFiles = this.mNativeCrashHandler.listCompleteSessionFiles();
        File[] performanceFiles = this.mPerformanceHandler.listCompleteSessionFiles();
        return CrashlyticsController.concatAll(apiFiles, anrFiles, wholeAnrFiles, javaCrashFiles, nativeCrasFiles, performanceFiles);
    }

    private File[] listCacheCompleteSessionFiles() {
        File[] apiFiles = this.mApiHandler.listCacheCompleteSessionFiles();
        File[] anrFiles = this.mAnrHandler.listCacheCompleteSessionFiles();
        File[] wholeAnrFile = this.mWholeAnrHandler.listCacheCompleteSessionFiles();
        File[] javaCrashFiles = this.mJavaCrashHandler.listCacheCompleteSessionFiles();
        File[] nativeCrashFiles = this.mNativeCrashHandler.listCacheCompleteSessionFiles();
        File[] performanceCacheFile = this.mPerformanceHandler.listCacheCompleteSessionFiles();
        return CrashlyticsController.concatAll(apiFiles, anrFiles, wholeAnrFile, javaCrashFiles, nativeCrashFiles, performanceCacheFile);
    }

    public void cleanInvalidTempFiles() {
        this.backgroundWorker.submit(new Runnable(){

            @Override
            public void run() {
                CrashlyticsController.this.doCleanInvalidTempFiles(CrashlyticsController.this.listFilesMatching(new InvalidPartFileFilter()));
            }
        });
    }

    private File[] listFilesMatching(FilenameFilter filter) {
        return this.listFilesMatching(this.getFilesDir(), filter);
    }

    private void doCleanInvalidTempFiles(File[] invalidFiles) {
        if (invalidFiles != null && invalidFiles.length != 0) {
            File invalidFilesDir = this.getInvalidFilesDir();
            if (!invalidFilesDir.exists()) {
                invalidFilesDir.mkdir();
            }
            for (File invalidFile : invalidFiles) {
                Logger.d("CrashlyticsCore", "Moving session file: " + invalidFile);
                if (invalidFile.renameTo(new File(invalidFilesDir, invalidFile.getName()))) continue;
                Logger.d("CrashlyticsCore", "Could not move session file. Deleting " + invalidFile);
                invalidFile.delete();
            }
            this.trimInvalidSessionFiles();
        }
    }

    private void trimInvalidSessionFiles() {
        File invalidFilesDir = this.getInvalidFilesDir();
        if (invalidFilesDir.exists()) {
            File[] oldInvalidFiles = this.listFilesMatching(invalidFilesDir, new InvalidPartFileFilter());
            Arrays.sort(oldInvalidFiles, Collections.reverseOrder());
            HashSet<String> sessionIdsToKeep = new HashSet<String>();
            for (int i = 0; i < oldInvalidFiles.length && sessionIdsToKeep.size() < 4; ++i) {
                sessionIdsToKeep.add(CrashlyticsController.getSessionIdFromSessionFile(oldInvalidFiles[i]));
            }
            this.retainSessions(this.listFiles(invalidFilesDir), sessionIdsToKeep);
        }
    }

    private void retainSessions(File[] files, Set<String> sessionIdsToKeep) {
        for (File sessionPartFile : files) {
            String fileName = sessionPartFile.getName();
            Matcher matcher = SESSION_FILE_PATTERN.matcher(fileName);
            if (!matcher.matches()) {
                Logger.d("CrashlyticsCore", "Deleting unknown file: " + fileName);
                sessionPartFile.delete();
                continue;
            }
            String sessionId = matcher.group(1);
            if (sessionIdsToKeep.contains(sessionId)) continue;
            Logger.d("CrashlyticsCore", "Trimming session file: " + fileName);
            sessionPartFile.delete();
        }
    }

    private File[] listFiles(File directory) {
        return this.ensureFileArrayNotNull(directory.listFiles());
    }

    private static String getSessionIdFromSessionFile(File sessionFile) {
        return sessionFile.getName().substring(0, 35);
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    private File[] listFilesMatching(File directory, FilenameFilter filter) {
        return this.ensureFileArrayNotNull(directory.listFiles(filter));
    }

    private File[] ensureFileArrayNotNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    private File getFilesDir() {
        return this.fileStore.getFilesDir();
    }

    private File getInvalidFilesDir() {
        return new File(this.getFilesDir(), "invalidClsFiles");
    }

    public synchronized void submitAllReports(float delay) {
        if (this.canSendReports()) {
            if (this.mReportUploader == null) {
                CreateReportSpiCall call = this.getCreateReportSpiCall(Constants.getJavaReportsUrl(), Constants.getAnrReportsUrl());
                this.mReportUploader = new ReportUploader(call);
            }
            this.mReportUploader.uploadReports(delay, this.reportFilesProvider);
        }
    }

    private boolean canSendReports() {
        return !"0".equals(LocalUtils.getAutoCollectCrashLog(this.core.getContext()));
    }

    private CreateReportSpiCall getCreateReportSpiCall(String reportsUrl, String anrReportsUrl) {
        DefaultCreateReportSpiCall defaultCreateReportSpiCall = new DefaultCreateReportSpiCall(reportsUrl, this.httpRequestFactory);
        DefaultCreateReportSpiCall anrCreateReportSpiCall = new DefaultCreateReportSpiCall(anrReportsUrl, this.httpRequestFactory);
        return new CompositeCreateReportSpiCall(defaultCreateReportSpiCall, anrCreateReportSpiCall);
    }

    public void updateAppInfo() {
        final UpdateAppSpiCall updateAppSpiCall = new UpdateAppSpiCall(Constants.getAppVersionUrl(), this.httpRequestFactory);
        final Context context = this.core.getContext();
        this.backgroundWorker.submit(new Runnable(){

            @Override
            public void run() {
                updateAppSpiCall.invoke(new SettingsRequest(LocalUtils.getCorpUUID(context), context.getPackageName(), LocalUtils.getVersionCode(context)));
            }
        });
    }

    static class InvalidPartFileFilter
    implements FilenameFilter {
        InvalidPartFileFilter() {
        }

        @Override
        public boolean accept(File file, String fileName) {
            return fileName.endsWith("_temp");
        }
    }

    private final class ReportUploaderFilesProvider
    implements ReportUploader.ReportFilesProvider {
        private ReportUploaderFilesProvider() {
        }

        @Override
        public File[] getCompleteSessionFiles() {
            return CrashlyticsController.this.listCompleteSessionFiles();
        }

        @Override
        public File[] getCompleteCacheFiles() {
            return CrashlyticsController.this.listCacheCompleteSessionFiles();
        }

        @Override
        public File getFilesDir() {
            return CrashlyticsController.this.getFilesDir();
        }

        @Override
        public File[] getInvalidSessionFiles() {
            return CrashlyticsController.this.listFilesMatching(CrashlyticsController.this.getInvalidFilesDir(), new InvalidPartFileFilter());
        }
    }
}

