/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.trace.tracer;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.plugin.PluginHandler;
import com.ainirobot.base.report.ReportData;
import com.ainirobot.base.trace.TracePlugin;
import com.ainirobot.base.trace.config.TraceConfig;
import com.ainirobot.base.trace.core.UIThreadMonitor;
import com.ainirobot.base.trace.listeners.IDoFrameListener;
import com.ainirobot.base.trace.tracer.Tracer;
import com.ainirobot.base.trace.util.Utils;
import com.ainirobot.base.util.ActivityUtils;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.OrionBaseHandlerThread;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class FrameTracer
extends Tracer {
    private final HashSet<IDoFrameListener> listeners = new HashSet();
    private final long frameIntervalMs;
    private final TraceConfig config;
    private boolean isFPSEnable;
    private long frozenThreshold;
    private long middleThreshold;
    private long backgroundFrameCount;
    private FPSCollector mFPSCollector;
    private Activity mShowingActivity;
    private Context mContext;
    private Handler mHandler;
    private PluginHandler mPluginHandler;
    private boolean mIsForeground;
    private final Application.ActivityLifecycleCallbacks mActivityLifecycleCallback = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle bundle) {
            Logger.d("activity create:" + activity.getClass().getSimpleName(), new Object[0]);
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
            FrameTracer.this.mIsForeground = true;
            FrameTracer.this.onShow(activity);
        }

        public void onActivityPaused(Activity activity) {
            FrameTracer.this.mIsForeground = false;
            FrameTracer.this.onDissmiss();
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };

    public FrameTracer(TracePlugin plugin) {
        this.mContext = plugin.getApplicationContext();
        this.mHandler = new Handler(OrionBaseHandlerThread.getDefaultHandlerThread().getLooper());
        this.config = plugin.getConfig();
        this.frameIntervalMs = TimeUnit.MILLISECONDS.convert(UIThreadMonitor.getMonitor().getFrameIntervalNanos(), TimeUnit.NANOSECONDS) + 1L;
        this.isFPSEnable = this.config.isFPSEnable();
        this.frozenThreshold = this.config.getFrozenThreshold();
        this.middleThreshold = this.config.getMiddleThreshold();
        Logger.d("[init] frameIntervalMs:%s isFPSEnable:%s", this.frameIntervalMs, this.isFPSEnable);
        if (this.isFPSEnable) {
            this.mFPSCollector = new FPSCollector();
        }
    }

    @Override
    public void onStartTrace() {
        super.onStartTrace();
        if (this.isFPSEnable && this.mFPSCollector != null) {
            this.addListener(this.mFPSCollector);
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (FrameTracer.this.mShowingActivity == null) {
                    FrameTracer.this.checkCurrentActivity();
                }
            }
        }, this.config.getPageCheckThreshold());
        this.detectFpsInfo();
    }

    private void checkCurrentActivity() {
        try {
            Activity activity = ActivityUtils.getGlobalActivity();
            this.onShow(activity);
        }
        catch (Exception e) {
            Logger.d("checkCurrentActivity() e:" + e.getLocalizedMessage(), new Object[0]);
        }
    }

    private void detectFpsInfo() {
        Logger.d("OrionBase", "detectFpsInfo");
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject data;
                    if (FrameTracer.this.mPluginHandler != null && (data = FrameTracer.this.getFpsJson()) != null && !Constants.ENABLE_DOMAIN_GLOBAL) {
                        ReportData reportData = new ReportData();
                        reportData.type = 5;
                        reportData.data = data;
                        FrameTracer.this.mPluginHandler.handleData(reportData);
                        FrameTracer.this.mFPSCollector.clear();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FrameTracer.this.detectFpsInfo();
            }
        }, this.config.getReportThreshold());
    }

    private void onShow(Activity activity) {
        Logger.d("frame tracer core onShow activity = " + activity, new Object[0]);
        int hashCode = activity.getClass().hashCode();
        if (this.mShowingActivity != null && this.mShowingActivity.getClass().hashCode() == hashCode) {
            return;
        }
        this.mShowingActivity = activity;
    }

    private void onDissmiss() {
        this.mShowingActivity = null;
    }

    public void addListener(IDoFrameListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IDoFrameListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onAlive() {
        super.onAlive();
        if (this.mContext instanceof Application) {
            ((Application)this.mContext).registerActivityLifecycleCallbacks(this.mActivityLifecycleCallback);
        }
        UIThreadMonitor.getMonitor().addObserver(this);
    }

    @Override
    public void onDead() {
        super.onDead();
        if (this.mContext instanceof Application) {
            ((Application)this.mContext).unregisterActivityLifecycleCallbacks(this.mActivityLifecycleCallback);
        }
        UIThreadMonitor.getMonitor().removeObserver(this);
        this.clear();
    }

    @Override
    public void doFrame(String focusedActivityName, long start, long end, long frameCostMs, long inputCostNs, long animationCostNs, long traversalCostNs) {
        if (this.mIsForeground) {
            this.notifyListener(focusedActivityName, frameCostMs);
        }
    }

    @Override
    public void onForeground(boolean isForeground) {
        super.onForeground(isForeground);
        if (isForeground) {
            if (this.backgroundFrameCount > 300L) {
                Logger.e("wrong! why do frame[%s] in background!!!", this.backgroundFrameCount);
            }
            this.backgroundFrameCount = 0L;
        }
    }

    private void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(final String focusedActivityName, final long frameCostMs) {
        long start = System.currentTimeMillis();
        try {
            for (final IDoFrameListener listener : this.listeners) {
                final int dropFrame = (int)(frameCostMs / this.frameIntervalMs);
                listener.doFrameSync(focusedActivityName, frameCostMs, dropFrame);
                if (null == listener.getHandler()) continue;
                listener.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        listener.doFrameAsync(focusedActivityName, frameCostMs, dropFrame);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            long cost = System.currentTimeMillis() - start;
            if (cost > this.frameIntervalMs) {
                Logger.w("[notifyListener] warm! maybe do heavy work in doFrameSync,but you can replace with doFrameAsync! cost:%sms", cost);
            }
            if (this.config.isDebug() && !this.isForeground()) {
                ++this.backgroundFrameCount;
            }
            throw throwable;
        }
        long cost = System.currentTimeMillis() - start;
        if (cost > this.frameIntervalMs) {
            Logger.w("[notifyListener] warm! maybe do heavy work in doFrameSync,but you can replace with doFrameAsync! cost:%sms", cost);
        }
        if (this.config.isDebug() && !this.isForeground()) {
            ++this.backgroundFrameCount;
        }
    }

    public JSONObject getFpsJson() {
        if (this.mFPSCollector != null) {
            try {
                JSONObject fpsJson = new JSONObject();
                ConcurrentHashMap<String, FrameCollectItem> frameCollectItemsMap = this.mFPSCollector.getFrameCollectItems();
                if (frameCollectItemsMap.size() > 0) {
                    Set keys = frameCollectItemsMap.keySet();
                    for (String key : keys) {
                        FrameCollectItem collectItem = frameCollectItemsMap.get(key);
                        if (collectItem == null) continue;
                        fpsJson.put("page_name", (Object)key);
                        fpsJson.put("fps_info", (Object)collectItem.getData());
                    }
                    return fpsJson;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void clearData() {
        if (this.mFPSCollector != null) {
            this.mFPSCollector.clear();
        }
    }

    public void setPluginHandler(PluginHandler handler) {
        this.mPluginHandler = handler;
    }

    private static enum DropStatus {
        DROPPED_CATON(2),
        DROPPED_SLOW(1),
        DROPPED_NORMAL(0);

        int index;

        private DropStatus(int index) {
            this.index = index;
        }
    }

    private class FrameCollectItem {
        String focusedActivityName;
        long sumFrameCost;
        int sumFrame = 0;
        int sumDroppedFrames;
        int[] dropLevel = new int[DropStatus.values().length];

        FrameCollectItem(String focusedActivityName) {
            this.focusedActivityName = focusedActivityName;
        }

        void collect(int droppedFrames) {
            long frameIntervalCost = UIThreadMonitor.getMonitor().getFrameIntervalNanos();
            this.sumFrameCost += (long)(droppedFrames + 1) * frameIntervalCost / 1000000L;
            this.sumDroppedFrames += droppedFrames;
            ++this.sumFrame;
            if ((long)droppedFrames >= FrameTracer.this.frozenThreshold) {
                int n = DropStatus.DROPPED_CATON.index;
                this.dropLevel[n] = this.dropLevel[n] + 1;
            } else if ((long)droppedFrames >= FrameTracer.this.middleThreshold) {
                int n = DropStatus.DROPPED_SLOW.index;
                this.dropLevel[n] = this.dropLevel[n] + 1;
            } else {
                int n = DropStatus.DROPPED_NORMAL.index;
                this.dropLevel[n] = this.dropLevel[n] + 1;
            }
        }

        JSONObject getData() {
            try {
                JSONObject dropLevelObject = new JSONObject();
                dropLevelObject.put("caton", this.dropLevel[DropStatus.DROPPED_CATON.index]);
                dropLevelObject.put("slow", this.dropLevel[DropStatus.DROPPED_SLOW.index]);
                dropLevelObject.put("normal", this.dropLevel[DropStatus.DROPPED_NORMAL.index]);
                return dropLevelObject;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "focusedActivityName=" + this.focusedActivityName + ", sumFrame=" + this.sumFrame + ", sumDroppedFrames=" + this.sumDroppedFrames + ", sumFrameCost=" + this.sumFrameCost + ", dropLevel=" + Arrays.toString(this.dropLevel);
        }
    }

    private class FPSCollector
    extends IDoFrameListener {
        private Handler frameHandler = new Handler(OrionBaseHandlerThread.getDefaultHandlerThread().getLooper());
        private ConcurrentHashMap<String, FrameCollectItem> map = new ConcurrentHashMap();

        private FPSCollector() {
        }

        @Override
        public Handler getHandler() {
            return this.frameHandler;
        }

        @Override
        public void doFrameAsync(String activityName, long frameCost, int droppedFrames) {
            String focusedActivityName;
            super.doFrameAsync(activityName, frameCost, droppedFrames);
            if (FrameTracer.this.mShowingActivity == null) {
                return;
            }
            try {
                focusedActivityName = ActivityUtils.getVisibleFragmentTag(FrameTracer.this.mShowingActivity);
            }
            catch (Exception e) {
                return;
            }
            if (Utils.isEmpty(focusedActivityName)) {
                return;
            }
            FrameCollectItem item = this.map.get(focusedActivityName);
            if (null == item) {
                item = new FrameCollectItem(focusedActivityName);
                this.map.put(focusedActivityName, item);
            }
            item.collect(droppedFrames);
        }

        ConcurrentHashMap<String, FrameCollectItem> getFrameCollectItems() {
            return this.map;
        }

        void clear() {
            this.map.clear();
        }
    }
}

