/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.trace.core;

import android.os.Looper;
import android.os.SystemClock;
import android.view.Choreographer;
import com.ainirobot.base.trace.config.TraceConfig;
import com.ainirobot.base.trace.core.BeatLifecycle;
import com.ainirobot.base.trace.core.LooperMonitor;
import com.ainirobot.base.trace.listeners.LooperObserver;
import com.ainirobot.base.trace.util.Utils;
import com.ainirobot.base.util.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;

public class UIThreadMonitor
implements BeatLifecycle,
Runnable {
    private static final String ADD_CALLBACK = "addCallbackLocked";
    private volatile boolean isAlive = false;
    private long[] dispatchTimeMs = new long[4];
    private final HashSet<LooperObserver> observers = new HashSet();
    private volatile long token = 0L;
    private boolean isBelongFrame = false;
    public static final int CALLBACK_INPUT = 0;
    public static final int CALLBACK_ANIMATION = 1;
    public static final int CALLBACK_TRAVERSAL = 2;
    public static final int DO_QUEUE_END_ERROR = -100;
    private static final int CALLBACK_LAST = 2;
    private static final UIThreadMonitor sInstance = new UIThreadMonitor();
    private TraceConfig config;
    private Object callbackQueueLock;
    private Object[] callbackQueues;
    private Method addTraversalQueue;
    private Method addInputQueue;
    private Method addAnimationQueue;
    private Choreographer choreographer;
    private long frameIntervalNanos = 16666666L;
    private int[] queueStatus = new int[3];
    private boolean[] callbackExist = new boolean[3];
    private long[] queueCost = new long[3];
    private static final int DO_QUEUE_DEFAULT = 0;
    private static final int DO_QUEUE_BEGIN = 1;
    private static final int DO_QUEUE_END = 2;
    private boolean isInit = false;

    public static UIThreadMonitor getMonitor() {
        return sInstance;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void init(TraceConfig config) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new AssertionError((Object)"must be init in main thread!");
        }
        this.isInit = true;
        this.config = config;
        this.choreographer = Choreographer.getInstance();
        this.callbackQueueLock = this.reflectObject(this.choreographer, "mLock");
        this.callbackQueues = (Object[])this.reflectObject(this.choreographer, "mCallbackQueues");
        this.addInputQueue = this.reflectChoreographerMethod(this.callbackQueues[0], ADD_CALLBACK, Long.TYPE, Object.class, Object.class);
        this.addAnimationQueue = this.reflectChoreographerMethod(this.callbackQueues[1], ADD_CALLBACK, Long.TYPE, Object.class, Object.class);
        this.addTraversalQueue = this.reflectChoreographerMethod(this.callbackQueues[2], ADD_CALLBACK, Long.TYPE, Object.class, Object.class);
        this.frameIntervalNanos = (Long)this.reflectObject(this.choreographer, "mFrameIntervalNanos");
        LooperMonitor.register(new LooperMonitor.LooperDispatchListener(){

            @Override
            public boolean isValid() {
                return UIThreadMonitor.this.isAlive;
            }

            @Override
            public void dispatchStart() {
                super.dispatchStart();
                UIThreadMonitor.this.dispatchBegin();
            }

            @Override
            public void dispatchEnd() {
                super.dispatchEnd();
                UIThreadMonitor.this.dispatchEnd();
            }
        });
        Logger.i("[UIThreadMonitor] %s %s %s %s %s frameIntervalNanos:%s", this.callbackQueueLock == null, this.callbackQueues == null, this.addInputQueue == null, this.addTraversalQueue == null, this.addAnimationQueue == null, this.frameIntervalNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFrameCallback(int type, Runnable callback, boolean isAddHeader) {
        if (this.callbackExist[type]) {
            if (Logger.debuggable()) {
                Logger.w("[addFrameCallback] this type %s callback has exist!", type);
            }
            return;
        }
        if (!this.isAlive && type == 0) {
            if (Logger.debuggable()) {
                Logger.w("[addFrameCallback] UIThreadMonitor is not alive!", new Object[0]);
            }
            return;
        }
        try {
            Object object = this.callbackQueueLock;
            synchronized (object) {
                Method method = null;
                switch (type) {
                    case 0: {
                        method = this.addInputQueue;
                        break;
                    }
                    case 1: {
                        method = this.addAnimationQueue;
                        break;
                    }
                    case 2: {
                        method = this.addTraversalQueue;
                    }
                }
                if (null != method) {
                    method.invoke(this.callbackQueues[type], !isAddHeader ? SystemClock.uptimeMillis() : -1L, callback, null);
                    this.callbackExist[type] = true;
                }
            }
        }
        catch (Exception e) {
            Logger.e(e.toString(), new Object[0]);
        }
    }

    public long getFrameIntervalNanos() {
        return this.frameIntervalNanos;
    }

    public void addObserver(LooperObserver observer) {
        if (!this.isAlive) {
            this.onStart();
        }
        this.observers.add(observer);
    }

    public void removeObserver(LooperObserver observer) {
        this.observers.remove(observer);
        if (this.observers.isEmpty()) {
            this.onStop();
        }
    }

    public long getQueueCost(int type, long token) {
        if (token != this.token) {
            return -1L;
        }
        return this.queueStatus[type] == 2 ? this.queueCost[type] : 0L;
    }

    private <T> T reflectObject(Object instance, String name) {
        try {
            Field field = instance.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.e(e.toString(), new Object[0]);
            return null;
        }
    }

    private Method reflectChoreographerMethod(Object instance, String name, Class<?> ... argTypes) {
        try {
            Method method = instance.getClass().getDeclaredMethod(name, argTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            Logger.e(e.toString(), new Object[0]);
            return null;
        }
    }

    private void dispatchBegin() {
        this.token = this.dispatchTimeMs[0] = SystemClock.uptimeMillis();
        this.dispatchTimeMs[2] = SystemClock.currentThreadTimeMillis();
        for (LooperObserver observer : this.observers) {
            if (observer.isDispatchBegin()) continue;
            observer.dispatchBegin(this.dispatchTimeMs[0], this.dispatchTimeMs[2], this.token);
        }
    }

    private void doFrameBegin(long token) {
        this.isBelongFrame = true;
    }

    private void doFrameEnd(long token) {
        this.doQueueEnd(2);
        for (int i : this.queueStatus) {
            if (i == 2) continue;
            this.queueCost[i] = -100L;
            if (!this.config.isDevEnv.booleanValue()) continue;
            throw new RuntimeException(String.format("UIThreadMonitor happens type[%s] != DO_QUEUE_END", i));
        }
        this.queueStatus = new int[3];
        long start = token;
        long end = SystemClock.uptimeMillis();
        for (LooperObserver observer : this.observers) {
            if (!observer.isDispatchBegin()) continue;
            observer.doFrame("default", start, end, end - start, this.queueCost[0], this.queueCost[1], this.queueCost[2]);
        }
        this.addFrameCallback(0, this, true);
        this.isBelongFrame = false;
    }

    private void dispatchEnd() {
        if (this.isBelongFrame) {
            this.doFrameEnd(this.token);
        }
        this.dispatchTimeMs[3] = SystemClock.currentThreadTimeMillis();
        this.dispatchTimeMs[1] = SystemClock.uptimeMillis();
        for (LooperObserver observer : this.observers) {
            if (!observer.isDispatchBegin()) continue;
            observer.dispatchEnd(this.dispatchTimeMs[0], this.dispatchTimeMs[2], this.dispatchTimeMs[1], this.dispatchTimeMs[3], this.token, this.isBelongFrame);
        }
    }

    private void doQueueBegin(int type) {
        this.queueStatus[type] = 1;
        this.queueCost[type] = System.nanoTime();
    }

    private void doQueueEnd(int type) {
        this.queueStatus[type] = 2;
        this.queueCost[type] = System.nanoTime() - this.queueCost[type];
        this.callbackExist[type] = false;
    }

    @Override
    public void onStart() {
        if (!this.isInit) {
            throw new RuntimeException("never init!");
        }
        if (!this.isAlive) {
            this.isAlive = true;
            this.addFrameCallback(0, this, true);
        }
    }

    @Override
    public void run() {
        long start = System.nanoTime();
        this.doFrameBegin(this.token);
        this.doQueueBegin(0);
        this.addFrameCallback(1, new Runnable(){

            @Override
            public void run() {
                UIThreadMonitor.this.doQueueEnd(0);
                UIThreadMonitor.this.doQueueBegin(1);
            }
        }, true);
        this.addFrameCallback(2, new Runnable(){

            @Override
            public void run() {
                UIThreadMonitor.this.doQueueEnd(1);
                UIThreadMonitor.this.doQueueBegin(2);
            }
        }, true);
    }

    @Override
    public void onStop() {
        if (!this.isInit) {
            throw new RuntimeException("UIThreadMonitor is never init!");
        }
        if (this.isAlive) {
            this.isAlive = false;
            Logger.i("[onStop] %s", Utils.getStack());
        }
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }
}

