/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.trace.core;

import android.os.Build;
import android.os.Looper;
import android.os.MessageQueue;
import android.support.annotation.CallSuper;
import android.util.Printer;
import com.ainirobot.base.util.Logger;
import java.lang.reflect.Field;
import java.util.HashSet;

public class LooperMonitor
implements MessageQueue.IdleHandler {
    private static final HashSet<LooperDispatchListener> listeners = new HashSet();
    private static Printer printer;
    private static final LooperMonitor monitor;

    private LooperMonitor() {
        LooperMonitor.resetPrinter();
        if (Build.VERSION.SDK_INT >= 23) {
            Looper.getMainLooper().getQueue().addIdleHandler((MessageQueue.IdleHandler)this);
        } else {
            MessageQueue queue = (MessageQueue)LooperMonitor.reflectObject(Looper.getMainLooper(), "mQueue");
            queue.addIdleHandler((MessageQueue.IdleHandler)this);
        }
    }

    public boolean queueIdle() {
        LooperMonitor.resetPrinter();
        return true;
    }

    private static void resetPrinter() {
        final Printer originPrinter = (Printer)LooperMonitor.reflectObject(Looper.getMainLooper(), "mLogging");
        if (originPrinter == printer && null != printer) {
            return;
        }
        if (null != printer) {
            Logger.w("[resetPrinter] maybe looper printer was replace other!", new Object[0]);
        }
        printer = new Printer(){
            boolean isHasChecked = false;
            boolean isValid = false;

            public void println(String x) {
                if (null != originPrinter) {
                    originPrinter.println(x);
                }
                if (!this.isHasChecked) {
                    this.isValid = x.charAt(0) == '>' || x.charAt(0) == '<';
                    this.isHasChecked = true;
                    if (!this.isValid && Logger.debuggable()) {
                        Logger.e("[println] Printer is inValid! x:%s", x);
                    }
                }
                if (this.isValid) {
                    LooperMonitor.dispatch(x.charAt(0) == '>');
                }
            }
        };
        Looper.getMainLooper().setMessageLogging(printer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(LooperDispatchListener listener) {
        HashSet<LooperDispatchListener> hashSet = listeners;
        synchronized (hashSet) {
            listeners.add(listener);
        }
    }

    private static void dispatch(boolean isBegin) {
        for (LooperDispatchListener listener : listeners) {
            if (listener.isValid()) {
                if (isBegin) {
                    if (listener.isHasDispatchStart) continue;
                    listener.dispatchStart();
                    continue;
                }
                if (!listener.isHasDispatchStart) continue;
                listener.dispatchEnd();
                continue;
            }
            if (isBegin || !listener.isHasDispatchStart) continue;
            listener.dispatchEnd();
        }
    }

    private static <T> T reflectObject(Object instance, String name) {
        try {
            Field field = instance.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.e(e.toString(), new Object[0]);
            return null;
        }
    }

    static {
        monitor = new LooperMonitor();
    }

    public static abstract class LooperDispatchListener {
        boolean isHasDispatchStart = false;

        boolean isValid() {
            return false;
        }

        @CallSuper
        void dispatchStart() {
            this.isHasDispatchStart = true;
        }

        @CallSuper
        void dispatchEnd() {
            this.isHasDispatchStart = false;
        }
    }
}

