/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.trace.config;

import com.ainirobot.base.plugin.IDynamicConfig;

public class TraceConfig {
    private static final long DEFAULT_CHECK_PAGE_THRESHOLD = 3000L;
    private static final boolean FPS_ENABLE = true;
    private static final boolean DEV_ENV_ENABLE = true;
    private static final boolean IS_DEBUG_ENABLE = true;
    public IDynamicConfig dynamicConfig;
    public Boolean defaultFpsEnable;
    public Boolean isDebug;
    public Boolean isDevEnv;

    private TraceConfig() {
    }

    public String toString() {
        StringBuilder ss = new StringBuilder(" \n");
        ss.append("# TraceConfig\n");
        ss.append("* isDebug:\t").append(this.isDebug).append("\n");
        ss.append("* isDevEnv:\t").append(this.isDevEnv).append("\n");
        ss.append("* defaultFpsEnable:\t").append(this.defaultFpsEnable).append("\n");
        return ss.toString();
    }

    public boolean isFPSEnable() {
        if (this.defaultFpsEnable == null) {
            return this.dynamicConfig.get(ExptEnum.orionbase_trace_fps_enable.name(), true);
        }
        return this.defaultFpsEnable;
    }

    public boolean isDebug() {
        if (this.isDebug == null) {
            return this.dynamicConfig.get(ExptEnum.orionbase_is_debug_enable.name(), true);
        }
        return this.isDebug;
    }

    public boolean isDevEnv() {
        if (this.isDevEnv == null) {
            return this.dynamicConfig.get(ExptEnum.orionbase_dev_env_enable.name(), true);
        }
        return this.isDevEnv;
    }

    public long getPageCheckThreshold() {
        return this.dynamicConfig.get(ExptEnum.orionbase_check_page_time.name(), 3000L);
    }

    public int getFrozenThreshold() {
        return this.dynamicConfig.get(ExptEnum.orionbase_fps_dropped_frozen.name(), 42);
    }

    public int getMiddleThreshold() {
        return this.dynamicConfig.get(ExptEnum.orionbase_fps_dropped_middle.name(), 9);
    }

    public long getReportThreshold() {
        return this.dynamicConfig.get(ExptEnum.orionbase_fps_report.name(), 600000L);
    }

    public static class Builder {
        private TraceConfig config = new TraceConfig();

        public Builder dynamicConfig(IDynamicConfig dynamicConfig) {
            this.config.dynamicConfig = dynamicConfig;
            return this;
        }

        public Builder enableFPS(Boolean enable) {
            this.config.defaultFpsEnable = enable;
            return this;
        }

        public Builder isDebug(boolean isDebug) {
            this.config.isDebug = isDebug;
            return this;
        }

        public Builder isDevEnv(boolean isDevEnv) {
            this.config.isDevEnv = isDevEnv;
            return this;
        }

        public TraceConfig build() {
            return this.config;
        }
    }

    public static enum ExptEnum {
        orionbase_trace_fps_enable,
        orionbase_dev_env_enable,
        orionbase_is_debug_enable,
        orionbase_check_page_time,
        orionbase_fps_dropped_middle,
        orionbase_fps_dropped_frozen,
        orionbase_fps_report;

    }
}

