/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.trace;

import android.content.Context;
import android.os.Build;
import android.os.Looper;
import com.ainirobot.base.plugin.DefaultConfig;
import com.ainirobot.base.plugin.IDynamicConfig;
import com.ainirobot.base.plugin.Plugin;
import com.ainirobot.base.plugin.PluginListener;
import com.ainirobot.base.trace.config.TraceConfig;
import com.ainirobot.base.trace.core.UIThreadMonitor;
import com.ainirobot.base.trace.tracer.FrameTracer;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.OrionBaseHandlerThread;

public class TracePlugin
extends Plugin {
    private final TraceConfig traceConfig;
    private FrameTracer frameTracer;

    public TracePlugin() {
        this.traceConfig = new TraceConfig.Builder().dynamicConfig(new DefaultConfig()).build();
    }

    public TracePlugin(IDynamicConfig config) {
        this.traceConfig = config == null ? new TraceConfig.Builder().dynamicConfig(new DefaultConfig()).build() : new TraceConfig.Builder().dynamicConfig(config).build();
    }

    @Override
    public void init(Context context, PluginListener listener) {
        super.init(context, listener);
        Logger.i("trace plugin init, trace config: %s", this.traceConfig.toString());
        if (Build.VERSION.SDK_INT < 16) {
            Logger.e("[FrameBeat] API is low Build.VERSION_CODES.JELLY_BEAN(16), TracePlugin is not supported", new Object[0]);
            this.unSupportPlugin();
            return;
        }
        this.frameTracer = new FrameTracer(this);
        this.frameTracer.setPluginHandler(this.mPluginHandler);
    }

    public TraceConfig getConfig() {
        return this.traceConfig;
    }

    @Override
    public void start() {
        super.start();
        if (!this.isSupported()) {
            Logger.w("[start] Plugin is unSupported!", new Object[0]);
            return;
        }
        Logger.w("start!", new Object[0]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!UIThreadMonitor.getMonitor().isInit()) {
                    UIThreadMonitor.getMonitor().init(TracePlugin.this.traceConfig);
                }
                UIThreadMonitor.getMonitor().onStart();
                TracePlugin.this.frameTracer.onStartTrace();
            }
        };
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            Logger.w("start TracePlugin in Thread[%s] but not in mainThread!", Thread.currentThread().getId());
            OrionBaseHandlerThread.getDefaultMainHandler().post(runnable);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.isSupported()) {
            Logger.w("[stop] Plugin is unSupported!", new Object[0]);
            return;
        }
        Logger.w("stop!", new Object[0]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UIThreadMonitor.getMonitor().onStop();
                TracePlugin.this.frameTracer.onCloseTrace();
            }
        };
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            Logger.w("stop TracePlugin in Thread[%s] but not in mainThread!", Thread.currentThread().getId());
            OrionBaseHandlerThread.getDefaultMainHandler().post(runnable);
        }
    }

    @Override
    public void onForeground(boolean isForeground) {
        super.onForeground(isForeground);
        if (!this.isSupported()) {
            return;
        }
        if (this.frameTracer != null) {
            this.frameTracer.onForeground(isForeground);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public String getTag() {
        return "Trace";
    }

    public FrameTracer getFrameTracer() {
        return this.frameTracer;
    }

    public UIThreadMonitor getUIThreadMonitor() {
        if (UIThreadMonitor.getMonitor().isInit()) {
            return UIThreadMonitor.getMonitor();
        }
        return null;
    }
}

