/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.report;

import com.ainirobot.base.report.Report;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SessionReport
implements Report {
    private static final String TEMP_SUFFIX = "_cache";
    private final Map<String, String> customHeaders;
    private final File file;
    private final File[] files;

    public SessionReport(File file) {
        this(file, Collections.emptyMap());
    }

    public SessionReport(File file, Map<String, String> customHeaders) {
        this.file = this.tempFile(file);
        this.files = new File[]{file};
        this.customHeaders = new HashMap<String, String>(customHeaders);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File[] getFiles() {
        return this.files;
    }

    @Override
    public String getFileName() {
        return this.getFile().getName();
    }

    @Override
    public String getIdentifier() {
        String fileName = this.getFileName();
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return Collections.unmodifiableMap(this.customHeaders);
    }

    @Override
    public void remove() {
        Logger.d("Removing report at " + this.file.getPath(), new Object[0]);
        this.file.delete();
    }

    public File tempFile(File file) {
        String filePath = file.getAbsolutePath();
        File tempFile = new File(filePath + TEMP_SUFFIX);
        FileUtils.renameTempFile(file, tempFile);
        return tempFile;
    }

    @Override
    public void reset() {
        String tempFilePath = this.file.getAbsolutePath();
        if (tempFilePath.endsWith(TEMP_SUFFIX)) {
            int index = tempFilePath.lastIndexOf(TEMP_SUFFIX);
            String filePath = tempFilePath.substring(0, index);
            File nfile = new File(filePath);
            FileUtils.renameTempFile(this.file, nfile);
        }
    }

    @Override
    public Report.Type getType() {
        return Report.Type.PROBUF;
    }
}

