/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.report;

import android.util.Log;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.report.ANRReport;
import com.ainirobot.base.report.CreateReportSpiCall;
import com.ainirobot.base.report.Report;
import com.ainirobot.base.report.SessionReport;
import com.ainirobot.base.util.BackgroundPriorityRunnable;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class ReportUploader {
    private final CreateReportSpiCall createReportCall;
    private static final Object fileAccessLock = new Object();

    public ReportUploader(CreateReportSpiCall createReportCall) {
        this.createReportCall = createReportCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean forceUpload(Report report) {
        boolean removed = false;
        Object object = fileAccessLock;
        synchronized (object) {
            block17: {
                boolean sent = false;
                sent = this.createReportCall.invoke(report);
                Logger.i("Performance report upload " + (sent ? "complete: " : "FAILED: ") + report.getIdentifier(), new Object[0]);
                Log.e((String)"david", (String)("Performance report upload " + (sent ? "complete: " : "FAILED: ") + report.getIdentifier()));
                try {
                    if (sent && !Constants.BUILD_TYPE_UNIT_TEST) {
                        report.remove();
                        removed = true;
                        break block17;
                    }
                    report.reset();
                }
                catch (Exception e) {
                    Logger.e("Error occurred sending report reset status " + report, e);
                }
                break block17;
                catch (Exception e) {
                    try {
                        Logger.e("Error occurred sending report " + report, e);
                        Log.e((String)"david", (String)("Error occurred sending report " + report), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (sent && !Constants.BUILD_TYPE_UNIT_TEST) {
                                report.remove();
                                removed = true;
                            } else {
                                report.reset();
                            }
                        }
                        catch (Exception e2) {
                            Logger.e("Error occurred sending report reset status " + report, e2);
                        }
                        throw throwable;
                    }
                    try {
                        if (sent && !Constants.BUILD_TYPE_UNIT_TEST) {
                            report.remove();
                            removed = true;
                        }
                        report.reset();
                    }
                    catch (Exception e3) {
                        Logger.e("Error occurred sending report reset status " + report, e3);
                    }
                }
            }
        }
        return removed;
    }

    public synchronized void uploadReports(float delay, ReportFilesProvider reportFilesProvider) {
        Worker worker = new Worker(delay, reportFilesProvider);
        worker.onRun();
    }

    private class Worker
    extends BackgroundPriorityRunnable {
        private final float delay;
        private ReportFilesProvider reportFilesProvider;

        Worker(float delay, ReportFilesProvider reportFilesProvider) {
            this.delay = delay;
            this.reportFilesProvider = reportFilesProvider;
        }

        @Override
        public void onRun() {
            try {
                this.attemptUpload();
            }
            catch (Exception e) {
                Logger.e("An unexpected error occurred while attempting to upload crash reports.", e);
            }
        }

        private void attemptUpload() {
            Logger.d("Starting report processing in " + this.delay + " second(s)...", new Object[0]);
            if (this.delay > 0.0f) {
                try {
                    Thread.sleep((long)(this.delay * 1000.0f));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            List<Report> reports = this.findReports();
            Logger.d("Attempting to send " + reports.size() + " report(s)", new Object[0]);
            if (reports != null && reports.size() > 0) {
                for (Report report : reports) {
                    ReportUploader.this.forceUpload(report);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Report> findReports() {
            File[] invalidTempFiles;
            File[] rpFiles;
            Logger.d("Checking for crash reports...", new Object[0]);
            Object object = fileAccessLock;
            synchronized (object) {
                File[] cacheFiles;
                File[] fileArray = cacheFiles = this.reportFilesProvider.getCompleteCacheFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File cacheFile = fileArray[i];
                    String cacheFilePath = cacheFile.getAbsolutePath();
                    int index = cacheFilePath.indexOf("_cache");
                    if (index <= 0) continue;
                    String filePath = cacheFilePath.substring(0, index);
                    File file = new File(filePath);
                    FileUtils.renameTempFile(cacheFile, file);
                }
                rpFiles = this.reportFilesProvider.getCompleteSessionFiles();
                invalidTempFiles = this.reportFilesProvider.getInvalidSessionFiles();
            }
            LinkedList<Report> reports = new LinkedList<Report>();
            if (rpFiles != null) {
                for (File file : rpFiles) {
                    Logger.d("Found crash report " + file.getPath(), new Object[0]);
                    if (file.getPath().endsWith(".anr")) {
                        reports.add(new ANRReport(this.reportFilesProvider.getFilesDir(), file));
                        continue;
                    }
                    reports.add(new SessionReport(file));
                }
            }
            if (reports.isEmpty()) {
                Logger.d("No reports found.", new Object[0]);
            }
            if (invalidTempFiles != null) {
                for (File file : invalidTempFiles) {
                    Logger.d("Found invalid temp report " + file.getPath(), new Object[0]);
                    if (file.getName().endsWith("anr_temp")) {
                        file.delete();
                        continue;
                    }
                    reports.add(new SessionReport(file));
                }
            }
            return reports;
        }
    }

    public static interface ReportFilesProvider {
        public File[] getCompleteSessionFiles();

        public File[] getCompleteCacheFiles();

        public File getFilesDir();

        public File[] getInvalidSessionFiles();
    }
}

