/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.report;

import com.ainirobot.base.report.Issue;
import java.util.HashSet;

public class IssuePublisher {
    private final OnIssueDetectListener mIssueListener;
    private final HashSet<String> mPublishedMap = new HashSet();

    public IssuePublisher(OnIssueDetectListener issueDetectListener) {
        this.mIssueListener = issueDetectListener;
    }

    protected void publishIssue(Issue issue) {
        if (this.mIssueListener == null) {
            throw new RuntimeException("publish issue, but issue listener is null");
        }
        if (issue != null) {
            this.mIssueListener.onDetectIssue(issue);
        }
    }

    protected boolean isPublished(String key) {
        if (key == null) {
            return false;
        }
        return this.mPublishedMap.contains(key);
    }

    protected void markPublished(String key) {
        if (key == null) {
            return;
        }
        this.mPublishedMap.add(key);
    }

    protected void unMarkPublished(String key) {
        if (key == null) {
            return;
        }
        this.mPublishedMap.remove(key);
    }

    public static interface OnIssueDetectListener {
        public void onDetectIssue(Issue var1);
    }
}

