/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.report;

import com.ainirobot.base.network.HttpMethod;
import com.ainirobot.base.network.HttpRequest;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.network.ResponseParser;
import com.ainirobot.base.report.AbstractSpiCall;
import com.ainirobot.base.report.CreateReportSpiCall;
import com.ainirobot.base.report.Report;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.util.Date;
import java.util.Map;

public class DefaultCreateReportSpiCall
extends AbstractSpiCall
implements CreateReportSpiCall {
    static final String FILE_CONTENT_TYPE = "application/octet-stream";
    static final String FILE_PARAM = "report[file]";
    static final String IDENTIFIER_PARAM = "report[identifier]";
    static final String MULTI_FILE_PARAM = "report[file";
    static final String SEND_TIME = "sendTime";

    public DefaultCreateReportSpiCall(String url, HttpRequestFactory requestFactory) {
        super(url, requestFactory, HttpMethod.POST);
    }

    DefaultCreateReportSpiCall(String url, HttpRequestFactory requestFactory, HttpMethod method) {
        super(url, requestFactory, method);
    }

    @Override
    public boolean invoke(Report report) {
        HttpRequest httpRequest = this.applyMultipartDataTo(this.applyHeadersTo(this.getHttpRequest(), report), report);
        Logger.d("Sending report to: " + this.getUrl(), new Object[0]);
        int statusCode = httpRequest.code();
        Logger.d("Result was: " + statusCode, new Object[0]);
        byte[] bodyBytes = httpRequest.body().getBytes();
        Logger.d("body [0] was: " + bodyBytes[0], new Object[0]);
        if (bodyBytes[0] == 1) {
            Logger.d("Result was: " + statusCode + ", parse success", new Object[0]);
        } else if (bodyBytes[0] == 0) {
            Logger.d("Result was: " + statusCode + ", parse failure", new Object[0]);
        }
        return ResponseParser.parse(statusCode) == 0 && bodyBytes[0] == 1;
    }

    private HttpRequest applyHeadersTo(HttpRequest request, Report report) {
        for (Map.Entry<String, String> entry : report.getCustomHeaders().entrySet()) {
            request = request.header(entry);
        }
        return request;
    }

    private HttpRequest applyMultipartDataTo(HttpRequest request, Report report) {
        request.part(SEND_TIME, new Date().getTime());
        if (report.getFiles().length == 1) {
            Logger.d("Adding single file " + report.getFileName() + " to report " + report.getIdentifier(), new Object[0]);
            return request.part(FILE_PARAM, report.getFileName(), FILE_CONTENT_TYPE, report.getFile());
        }
        int i = 0;
        for (File file : report.getFiles()) {
            Logger.d("Adding file " + file.getName() + " to report " + report.getIdentifier(), new Object[0]);
            if (file.getPath().endsWith(".anr_cache")) {
                String fileName = file.getName().replace("_cache", "");
                request.part(MULTI_FILE_PARAM + i + "]", fileName, FILE_CONTENT_TYPE, file, true);
            } else {
                request.part(MULTI_FILE_PARAM + i + "]", file.getName(), FILE_CONTENT_TYPE, file);
            }
            ++i;
        }
        return request;
    }
}

