/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.report;

import com.ainirobot.base.network.HttpMethod;
import com.ainirobot.base.network.HttpRequest;
import com.ainirobot.base.network.HttpRequestFactory;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstractSpiCall {
    public static final String ACCEPT_JSON_VALUE = "application/json";
    public static final String ANDROID_CLIENT_TYPE = "android";
    public static final String CLS_ANDROID_SDK_DEVELOPER_TOKEN = "470fa2b4ae81cd56ecbcda9735803434cec591fa";
    public static final String CRASHLYTICS_USER_AGENT = "Crashlytics Android SDK/";
    public static final int DEFAULT_TIMEOUT = 10000;
    private static final Pattern PROTOCOL_AND_HOST_PATTERN = Pattern.compile("http(s?)://[^\\/]+", 2);
    private final HttpMethod method;
    private final HttpRequestFactory requestFactory;
    private final String url;

    public AbstractSpiCall(String url, HttpRequestFactory requestFactory, HttpMethod method) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null.");
        }
        if (requestFactory == null) {
            throw new IllegalArgumentException("requestFactory must not be null.");
        }
        this.url = url;
        this.requestFactory = requestFactory;
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpRequest getHttpRequest() {
        return this.getHttpRequest(Collections.emptyMap());
    }

    public HttpRequest getHttpRequest(Map<String, String> queryParams) {
        return this.requestFactory.buildHttpRequest(this.method, this.getUrl(), queryParams).useCaches(false).connectTimeout(10000).header("User-Agent", CRASHLYTICS_USER_AGENT);
    }
}

