/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.report;

import com.ainirobot.base.report.Report;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ANRReport
implements Report {
    private static final String TEMP_SUFFIX = "_cache";
    private final Map<String, String> customHeaders;
    private final File reportDirectory;
    private final File anrSession;
    private final FilenameFilter filenameFilter;

    public ANRReport(File reportDirectory, File anrSession) {
        this.reportDirectory = reportDirectory;
        this.anrSession = this.tempFile(anrSession);
        this.filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.contains(ANRReport.this.getIdentifier());
            }
        };
        this.customHeaders = new HashMap<String, String>(Collections.emptyMap());
    }

    @Override
    public void remove() {
        File[] files;
        for (File file : files = this.getFiles()) {
            Logger.d("CrashlyticsCore", "Removing anr report file at " + file.getPath());
            file.delete();
        }
    }

    public File tempFile(File file) {
        String filePath = file.getAbsolutePath();
        File tempFile = new File(filePath + TEMP_SUFFIX);
        FileUtils.renameTempFile(file, tempFile);
        return tempFile;
    }

    @Override
    public void reset() {
        String tempFilePath = this.anrSession.getAbsolutePath();
        if (tempFilePath.endsWith(TEMP_SUFFIX)) {
            int index = tempFilePath.lastIndexOf(TEMP_SUFFIX);
            String filePath = tempFilePath.substring(0, index);
            File nfile = new File(filePath);
            FileUtils.renameTempFile(this.anrSession, nfile);
        }
    }

    @Override
    public String getFileName() {
        return this.getFile().getName();
    }

    @Override
    public String getIdentifier() {
        String fileName = this.getFileName();
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    @Override
    public File getFile() {
        return this.anrSession;
    }

    @Override
    public File[] getFiles() {
        return this.listFilesMatching(this.reportDirectory, this.filenameFilter);
    }

    private File[] ensureFileArrayNotNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    private File[] listFilesMatching(File directory, FilenameFilter filter) {
        return this.ensureFileArrayNotNull(directory.listFiles(filter));
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return Collections.unmodifiableMap(this.customHeaders);
    }

    @Override
    public Report.Type getType() {
        return Report.Type.ANR;
    }
}

