/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.protocol.nano;

import com.ainirobot.base.protocol.nano.MessageNano;
import com.ainirobot.base.protocol.nano.WireFormatNano;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class CodedOutputByteBufferNano {
    private static final int MAX_UTF8_EXPANSION = 3;
    private final ByteBuffer buffer;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    private CodedOutputByteBufferNano(byte[] buffer, int offset, int length) {
        this(ByteBuffer.wrap(buffer, offset, length));
    }

    private CodedOutputByteBufferNano(ByteBuffer buffer) {
        this.buffer = buffer;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static CodedOutputByteBufferNano newInstance(byte[] flatArray) {
        return CodedOutputByteBufferNano.newInstance(flatArray, 0, flatArray.length);
    }

    public static CodedOutputByteBufferNano newInstance(byte[] flatArray, int offset, int length) {
        return new CodedOutputByteBufferNano(flatArray, offset, length);
    }

    public void writeDouble(int fieldNumber, double value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeDoubleNoTag(value);
    }

    public void writeFloat(int fieldNumber, float value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFloatNoTag(value);
    }

    public void writeUInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value);
    }

    public void writeInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt64NoTag(value);
    }

    public void writeInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value);
    }

    public void writeFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeFixed64NoTag(value);
    }

    public void writeFixed32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFixed32NoTag(value);
    }

    public void writeBool(int fieldNumber, boolean value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeBoolNoTag(value);
    }

    public void writeString(int fieldNumber, String value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeStringNoTag(value);
    }

    public void writeGroup(int fieldNumber, MessageNano value) throws IOException {
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag(value);
        this.writeTag(fieldNumber, 4);
    }

    public void writeMessage(int fieldNumber, MessageNano value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeMessageNoTag(value);
    }

    public void writeBytes(int fieldNumber, byte[] value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value);
    }

    public void writeUInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeEnum(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeEnumNoTag(value);
    }

    public void writeSFixed32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeSFixed32NoTag(value);
    }

    public void writeSFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeSFixed64NoTag(value);
    }

    public void writeSInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt32NoTag(value);
    }

    public void writeSInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt64NoTag(value);
    }

    public void writeDoubleNoTag(double value) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToLongBits(value));
    }

    public void writeFloatNoTag(float value) throws IOException {
        this.writeRawLittleEndian32(Float.floatToIntBits(value));
    }

    public void writeUInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(value);
    }

    public void writeInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(value);
    }

    public void writeInt32NoTag(int value) throws IOException {
        if (value >= 0) {
            this.writeRawVarint32(value);
        } else {
            this.writeRawVarint64(value);
        }
    }

    public void writeFixed64NoTag(long value) throws IOException {
        this.writeRawLittleEndian64(value);
    }

    public void writeFixed32NoTag(int value) throws IOException {
        this.writeRawLittleEndian32(value);
    }

    public void writeBoolNoTag(boolean value) throws IOException {
        this.writeRawByte(value ? 1 : 0);
    }

    public void writeStringNoTag(String value) throws IOException {
        try {
            int minLengthVarIntSize = CodedOutputByteBufferNano.computeRawVarint32Size(value.length());
            int maxLengthVarIntSize = CodedOutputByteBufferNano.computeRawVarint32Size(value.length() * 3);
            if (minLengthVarIntSize == maxLengthVarIntSize) {
                int oldPosition = this.buffer.position();
                if (this.buffer.remaining() < minLengthVarIntSize) {
                    throw new OutOfSpaceException(oldPosition + minLengthVarIntSize, this.buffer.limit());
                }
                this.buffer.position(oldPosition + minLengthVarIntSize);
                CodedOutputByteBufferNano.encode(value, this.buffer);
                int newPosition = this.buffer.position();
                this.buffer.position(oldPosition);
                this.writeRawVarint32(newPosition - oldPosition - minLengthVarIntSize);
                this.buffer.position(newPosition);
            } else {
                this.writeRawVarint32(CodedOutputByteBufferNano.encodedLength(value));
                CodedOutputByteBufferNano.encode(value, this.buffer);
            }
        }
        catch (BufferOverflowException e) {
            OutOfSpaceException outOfSpaceException = new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
            outOfSpaceException.initCause(e);
            throw outOfSpaceException;
        }
    }

    private static int encodedLength(CharSequence sequence) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += CodedOutputByteBufferNano.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return utf8Length;
    }

    private static void encode(CharSequence sequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int encoded = CodedOutputByteBufferNano.encode(sequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(encoded - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                BufferOverflowException boe = new BufferOverflowException();
                boe.initCause(e);
                throw boe;
            }
        } else {
            CodedOutputByteBufferNano.encodeDirect(sequence, byteBuffer);
        }
    }

    private static void encodeDirect(CharSequence sequence, ByteBuffer byteBuffer) {
        int utf16Length = sequence.length();
        for (int i = 0; i < utf16Length; ++i) {
            char low;
            char c = sequence.charAt(i);
            if (c < '\u0080') {
                byteBuffer.put((byte)c);
                continue;
            }
            if (c < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c));
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                byteBuffer.put((byte)(0x1E0 | c >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c));
                continue;
            }
            if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            int codePoint = Character.toCodePoint(c, low);
            byteBuffer.put((byte)(0xF0 | codePoint >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & codePoint >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & codePoint >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & codePoint));
        }
    }

    private static int encode(CharSequence sequence, byte[] bytes, int offset, int length) {
        char c;
        int i;
        int utf16Length = sequence.length();
        int j = offset;
        int limit = offset + length;
        for (i = 0; i < utf16Length && i + j < limit && (c = sequence.charAt(i)) < '\u0080'; ++i) {
            bytes[j + i] = (byte)c;
        }
        if (i == utf16Length) {
            return j + utf16Length;
        }
        j += i;
        while (i < utf16Length) {
            c = sequence.charAt(i);
            if (c < '\u0080' && j < limit) {
                bytes[j++] = (byte)c;
            } else if (c < '\u0800' && j <= limit - 2) {
                bytes[j++] = (byte)(0x3C0 | c >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                bytes[j++] = (byte)(0x1E0 | c >>> 12);
                bytes[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & c);
            } else if (j <= limit - 4) {
                char low;
                if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
                }
                int codePoint = Character.toCodePoint(c, low);
                bytes[j++] = (byte)(0xF0 | codePoint >>> 18);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint);
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + j);
            }
            ++i;
        }
        return j;
    }

    public void writeGroupNoTag(MessageNano value) throws IOException {
        value.writeTo(this);
    }

    public void writeMessageNoTag(MessageNano value) throws IOException {
        this.writeRawVarint32(value.getCachedSize());
        value.writeTo(this);
    }

    public void writeBytesNoTag(byte[] value) throws IOException {
        this.writeRawVarint32(value.length);
        this.writeRawBytes(value);
    }

    public void writeUInt32NoTag(int value) throws IOException {
        this.writeRawVarint32(value);
    }

    public void writeEnumNoTag(int value) throws IOException {
        this.writeRawVarint32(value);
    }

    public void writeSFixed32NoTag(int value) throws IOException {
        this.writeRawLittleEndian32(value);
    }

    public void writeSFixed64NoTag(long value) throws IOException {
        this.writeRawLittleEndian64(value);
    }

    public void writeSInt32NoTag(int value) throws IOException {
        this.writeRawVarint32(CodedOutputByteBufferNano.encodeZigZag32(value));
    }

    public void writeSInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(CodedOutputByteBufferNano.encodeZigZag64(value));
    }

    public static int computeDoubleSize(int fieldNumber, double value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeDoubleSizeNoTag(value);
    }

    public static int computeFloatSize(int fieldNumber, float value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeFloatSizeNoTag(value);
    }

    public static int computeUInt64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeUInt64SizeNoTag(value);
    }

    public static int computeInt64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeInt64SizeNoTag(value);
    }

    public static int computeInt32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeInt32SizeNoTag(value);
    }

    public static int computeFixed64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeFixed64SizeNoTag(value);
    }

    public static int computeFixed32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeFixed32SizeNoTag(value);
    }

    public static int computeBoolSize(int fieldNumber, boolean value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeBoolSizeNoTag(value);
    }

    public static int computeStringSize(int fieldNumber, String value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeStringSizeNoTag(value);
    }

    public static int computeGroupSize(int fieldNumber, MessageNano value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) * 2 + CodedOutputByteBufferNano.computeGroupSizeNoTag(value);
    }

    public static int computeMessageSize(int fieldNumber, MessageNano value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeMessageSizeNoTag(value);
    }

    public static int computeBytesSize(int fieldNumber, byte[] value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeBytesSizeNoTag(value);
    }

    public static int computeUInt32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeUInt32SizeNoTag(value);
    }

    public static int computeEnumSize(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeEnumSizeNoTag(value);
    }

    public static int computeSFixed32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeSFixed32SizeNoTag(value);
    }

    public static int computeSFixed64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeSFixed64SizeNoTag(value);
    }

    public static int computeSInt32Size(int fieldNumber, int value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeSInt32SizeNoTag(value);
    }

    public static int computeSInt64Size(int fieldNumber, long value) {
        return CodedOutputByteBufferNano.computeTagSize(fieldNumber) + CodedOutputByteBufferNano.computeSInt64SizeNoTag(value);
    }

    public static int computeDoubleSizeNoTag(double value) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float value) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long value) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(value);
    }

    public static int computeInt64SizeNoTag(long value) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(value);
    }

    public static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            return CodedOutputByteBufferNano.computeRawVarint32Size(value);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long value) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int value) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean value) {
        return 1;
    }

    public static int computeStringSizeNoTag(String value) {
        int length = CodedOutputByteBufferNano.encodedLength(value);
        return CodedOutputByteBufferNano.computeRawVarint32Size(length) + length;
    }

    public static int computeGroupSizeNoTag(MessageNano value) {
        return value.getSerializedSize();
    }

    public static int computeMessageSizeNoTag(MessageNano value) {
        int size = value.getSerializedSize();
        return CodedOutputByteBufferNano.computeRawVarint32Size(size) + size;
    }

    public static int computeBytesSizeNoTag(byte[] value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(value.length) + value.length;
    }

    public static int computeUInt32SizeNoTag(int value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(value);
    }

    public static int computeEnumSizeNoTag(int value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(value);
    }

    public static int computeSFixed32SizeNoTag(int value) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long value) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int value) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(CodedOutputByteBufferNano.encodeZigZag32(value));
    }

    public static int computeSInt64SizeNoTag(long value) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(CodedOutputByteBufferNano.encodeZigZag64(value));
    }

    public int spaceLeft() {
        return this.buffer.remaining();
    }

    public void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public int position() {
        return this.buffer.position();
    }

    public void reset() {
        this.buffer.clear();
    }

    public void writeRawByte(byte value) throws IOException {
        if (!this.buffer.hasRemaining()) {
            throw new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
        }
        this.buffer.put(value);
    }

    public void writeRawByte(int value) throws IOException {
        this.writeRawByte((byte)value);
    }

    public void writeRawBytes(byte[] value) throws IOException {
        this.writeRawBytes(value, 0, value.length);
    }

    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        if (this.buffer.remaining() < length) {
            throw new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
        }
        this.buffer.put(value, offset, length);
    }

    public void writeTag(int fieldNumber, int wireType) throws IOException {
        this.writeRawVarint32(WireFormatNano.makeTag(fieldNumber, wireType));
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(WireFormatNano.makeTag(fieldNumber, 0));
    }

    public void writeRawVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeRawVarint64(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value);
                return;
            }
            this.writeRawByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void writeRawLittleEndian32(int value) throws IOException {
        if (this.buffer.remaining() < 4) {
            throw new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
        }
        this.buffer.putInt(value);
    }

    public void writeRawLittleEndian64(long value) throws IOException {
        if (this.buffer.remaining() < 8) {
            throw new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
        }
        this.buffer.putLong(value);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    static int computeFieldSize(int number, int type, Object object) {
        switch (type) {
            case 8: {
                return CodedOutputByteBufferNano.computeBoolSize(number, (Boolean)object);
            }
            case 12: {
                return CodedOutputByteBufferNano.computeBytesSize(number, (byte[])object);
            }
            case 9: {
                return CodedOutputByteBufferNano.computeStringSize(number, (String)object);
            }
            case 2: {
                return CodedOutputByteBufferNano.computeFloatSize(number, ((Float)object).floatValue());
            }
            case 1: {
                return CodedOutputByteBufferNano.computeDoubleSize(number, (Double)object);
            }
            case 14: {
                return CodedOutputByteBufferNano.computeEnumSize(number, (Integer)object);
            }
            case 7: {
                return CodedOutputByteBufferNano.computeFixed32Size(number, (Integer)object);
            }
            case 5: {
                return CodedOutputByteBufferNano.computeInt32Size(number, (Integer)object);
            }
            case 13: {
                return CodedOutputByteBufferNano.computeUInt32Size(number, (Integer)object);
            }
            case 17: {
                return CodedOutputByteBufferNano.computeSInt32Size(number, (Integer)object);
            }
            case 15: {
                return CodedOutputByteBufferNano.computeSFixed32Size(number, (Integer)object);
            }
            case 3: {
                return CodedOutputByteBufferNano.computeInt64Size(number, (Long)object);
            }
            case 4: {
                return CodedOutputByteBufferNano.computeUInt64Size(number, (Long)object);
            }
            case 18: {
                return CodedOutputByteBufferNano.computeSInt64Size(number, (Long)object);
            }
            case 6: {
                return CodedOutputByteBufferNano.computeFixed64Size(number, (Long)object);
            }
            case 16: {
                return CodedOutputByteBufferNano.computeSFixed64Size(number, (Long)object);
            }
            case 11: {
                return CodedOutputByteBufferNano.computeMessageSize(number, (MessageNano)object);
            }
            case 10: {
                return CodedOutputByteBufferNano.computeGroupSize(number, (MessageNano)object);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    void writeField(int number, int type, Object value) throws IOException {
        switch (type) {
            case 1: {
                Double doubleValue = (Double)value;
                this.writeDouble(number, doubleValue);
                break;
            }
            case 2: {
                Float floatValue = (Float)value;
                this.writeFloat(number, floatValue.floatValue());
                break;
            }
            case 3: {
                Long int64Value = (Long)value;
                this.writeInt64(number, int64Value);
                break;
            }
            case 4: {
                Long uint64Value = (Long)value;
                this.writeUInt64(number, uint64Value);
                break;
            }
            case 5: {
                Integer int32Value = (Integer)value;
                this.writeInt32(number, int32Value);
                break;
            }
            case 6: {
                Long fixed64Value = (Long)value;
                this.writeFixed64(number, fixed64Value);
                break;
            }
            case 7: {
                Integer fixed32Value = (Integer)value;
                this.writeFixed32(number, fixed32Value);
                break;
            }
            case 8: {
                Boolean boolValue = (Boolean)value;
                this.writeBool(number, boolValue);
                break;
            }
            case 9: {
                String stringValue = (String)value;
                this.writeString(number, stringValue);
                break;
            }
            case 12: {
                byte[] bytesValue = (byte[])value;
                this.writeBytes(number, bytesValue);
                break;
            }
            case 13: {
                Integer uint32Value = (Integer)value;
                this.writeUInt32(number, uint32Value);
                break;
            }
            case 14: {
                Integer enumValue = (Integer)value;
                this.writeEnum(number, enumValue);
                break;
            }
            case 15: {
                Integer sfixed32Value = (Integer)value;
                this.writeSFixed32(number, sfixed32Value);
                break;
            }
            case 16: {
                Long sfixed64Value = (Long)value;
                this.writeSFixed64(number, sfixed64Value);
                break;
            }
            case 17: {
                Integer sint32Value = (Integer)value;
                this.writeSInt32(number, sint32Value);
                break;
            }
            case 18: {
                Long sint64Value = (Long)value;
                this.writeSInt64(number, sint64Value);
                break;
            }
            case 11: {
                MessageNano messageValue = (MessageNano)value;
                this.writeMessage(number, messageValue);
                break;
            }
            case 10: {
                MessageNano groupValue = (MessageNano)value;
                this.writeGroup(number, groupValue);
                break;
            }
            default: {
                throw new IOException("Unknown type: " + type);
            }
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;

        OutOfSpaceException(int position, int limit) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + position + " limit " + limit + ").");
        }
    }
}

