/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.plugin;

import android.content.Context;
import com.ainirobot.base.plugin.IPlugin;
import com.ainirobot.base.plugin.PluginHandler;
import com.ainirobot.base.plugin.PluginListener;
import com.ainirobot.base.report.Issue;
import com.ainirobot.base.report.IssuePublisher;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.OrionBaseUtil;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Plugin<T>
implements IPlugin,
IssuePublisher.OnIssueDetectListener {
    public static final int PLUGIN_CREATE = 0;
    public static final int PLUGIN_INITED = 1;
    public static final int PLUGIN_STARTED = 2;
    public static final int PLUGIN_STOPPED = 4;
    public static final int PLUGIN_DESTROYED = 8;
    private PluginListener pluginListener;
    private Context context;
    private boolean isSupported = true;
    private int status = 0;
    protected PluginHandler<T> mPluginHandler;

    @Override
    public void init(Context context, PluginListener listener) {
        if (this.context != null || this.pluginListener != null) {
            throw new RuntimeException("plugin duplicate init, application or plugin listener is not null");
        }
        this.status = 1;
        this.context = context;
        this.pluginListener = listener;
    }

    public Plugin setPluginHandler(PluginHandler<T> handler) {
        this.mPluginHandler = handler;
        return this;
    }

    public void handleData(T data) {
        if (this.mPluginHandler != null) {
            this.mPluginHandler.handleData(data);
        }
    }

    @Override
    public void onDetectIssue(Issue issue) {
        if (issue.getTag() == null) {
            issue.setTag(this.getTag());
        }
        issue.setPlugin(this);
        JSONObject content = issue.getContent();
        try {
            if (issue.getTag() != null) {
                content.put("tag", (Object)issue.getTag());
            }
            if (issue.getType() != null) {
                content.put("type", (Object)issue.getType());
            }
            content.put("process", (Object)OrionBaseUtil.getProcessName(this.context));
            content.put("time", System.currentTimeMillis());
        }
        catch (JSONException e) {
            Logger.e("json error", new Object[]{e});
        }
        this.pluginListener.onReportIssue(issue);
    }

    @Override
    public Context getApplicationContext() {
        return this.context;
    }

    @Override
    public void start() {
        if (this.isPluginDestroyed()) {
            throw new RuntimeException("plugin start, but plugin has been already destroyed");
        }
        if (this.isPluginStarted()) {
            throw new RuntimeException("plugin start, but plugin has been already started");
        }
        this.status = 2;
        if (this.pluginListener == null) {
            throw new RuntimeException("plugin start, plugin listener is null");
        }
        this.pluginListener.onStart(this);
    }

    @Override
    public void stop() {
        if (this.isPluginDestroyed()) {
            throw new RuntimeException("plugin stop, but plugin has been already destroyed");
        }
        if (!this.isPluginStarted()) {
            throw new RuntimeException("plugin stop, but plugin is never started");
        }
        this.status = 4;
        if (this.pluginListener == null) {
            throw new RuntimeException("plugin stop, plugin listener is null");
        }
        this.pluginListener.onStop(this);
    }

    @Override
    public void destroy() {
        if (this.isPluginStarted()) {
            this.stop();
        }
        if (this.isPluginDestroyed()) {
            throw new RuntimeException("plugin destroy, but plugin has been already destroyed");
        }
        this.status = 8;
        if (this.pluginListener != null) {
            this.pluginListener.onDestroy(this);
        }
    }

    @Override
    public String getTag() {
        return this.getClass().getName();
    }

    @Override
    public void onForeground(boolean isForeground) {
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPluginStarted() {
        return this.status == 2;
    }

    public boolean isPluginStoped() {
        return this.status == 4;
    }

    public boolean isPluginDestroyed() {
        return this.status == 8;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public void unSupportPlugin() {
        this.isSupported = false;
    }
}

