/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.network;

import com.ainirobot.base.network.HttpMethod;
import com.ainirobot.base.network.HttpRequest;
import com.ainirobot.base.network.HttpRequestFactory;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    private static final String HTTPS = "https";

    @Override
    public HttpRequest buildHttpRequest(HttpMethod method, String url) {
        return this.buildHttpRequest(method, url, Collections.emptyMap());
    }

    @Override
    public HttpRequest buildHttpRequest(HttpMethod method, String url, Map<String, String> queryParams) {
        HttpRequest httpRequest;
        switch (method) {
            case GET: {
                httpRequest = HttpRequest.get((CharSequence)url, queryParams, true);
                break;
            }
            case POST: {
                httpRequest = HttpRequest.post((CharSequence)url, queryParams, true);
                break;
            }
            case PUT: {
                httpRequest = HttpRequest.put(url);
                break;
            }
            case DELETE: {
                httpRequest = HttpRequest.delete(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method!");
            }
        }
        return httpRequest;
    }

    private boolean isHttps(String url) {
        return url != null && url.toLowerCase(Locale.US).startsWith(HTTPS);
    }
}

