/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.dropbox;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.ainirobot.base.dropbox.DropBoxHandler;
import com.ainirobot.base.dropbox.DropBoxUtil;
import com.ainirobot.base.report.DropBoxData;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeCrashHandler
extends DropBoxHandler {
    @Override
    DropBoxData handleInner(Context context, String fileName) {
        DropBoxData data = null;
        try {
            long fileTime = NativeCrashHandler.parseTime(fileName);
            if (fileTime == -1L) {
                Log.d((String)"Zip", (String)("data_app_native_crash parseTime error, fileName = " + fileName));
                return null;
            }
            String orionFileName = DropBoxUtil.getFileName(fileName);
            Bundle nativeCrashBundle = null;
            String crashInfo = DropBoxUtil.getInstance().getText(fileName);
            nativeCrashBundle = NativeCrashHandler.parseNativeCrash(context, crashInfo, fileTime);
            if (nativeCrashBundle != null) {
                String cosUrl = DropBoxUtil.getBucketPath(orionFileName, fileTime);
                nativeCrashBundle.putString("key_cos_log_url", cosUrl);
                data = new DropBoxData();
                data.type = DropBoxData.NATIVE_CRASH;
                data.bundle = nativeCrashBundle;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    String[] supportType() {
        return new String[]{"data_app_native_crash", "system_app_native_crash"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bundle parseNativeCrash(Context context, String crashInfo, long lastModified) {
        Bundle bundle = null;
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new StringReader(crashInfo));
            String line = reader.readLine();
            String ABI = "ABI: ";
            while (line != null && !line.contains("ABI: ")) {
                line = reader.readLine();
            }
            int lastIndex = line.lastIndexOf("'");
            String abi = line.substring("ABI: ".length() + 1, lastIndex);
            String threadInfo = line = reader.readLine();
            String packageName = NativeCrashHandler.parsePackageName(line);
            String className = line = reader.readLine();
            StringBuilder nativeInfoBuilder = new StringBuilder();
            while (line != null && line.length() > 0) {
                line = reader.readLine();
                nativeInfoBuilder.append(line);
                nativeInfoBuilder.append("\n");
            }
            String nativeInfo = nativeInfoBuilder.toString();
            String backtraceHeader = "backtrace:";
            while (line != null && !line.contains("backtrace:")) {
                line = reader.readLine();
            }
            StringBuilder backtraceBuilder = new StringBuilder();
            while (line != null && line.length() > 0) {
                line = reader.readLine();
                if (line == null) continue;
                backtraceBuilder.append(line);
                backtraceBuilder.append("\n");
            }
            String backtrace = backtraceBuilder.toString();
            Log.w((String)"Zip", (String)("abi = " + abi));
            Log.w((String)"Zip", (String)("thread = " + threadInfo));
            Log.w((String)"Zip", (String)("className = " + className));
            Log.w((String)"Zip", (String)("native info = " + nativeInfo));
            Log.w((String)"Zip", (String)("backtrace = " + backtrace));
            bundle = new Bundle();
            bundle.putInt("key_collapse", 2);
            bundle.putString("key_source", "821");
            bundle.putInt("key_source_type", 2);
            bundle.putLong("key_ctime", lastModified);
            bundle.putString("abi", abi);
            bundle.putString("thread_info", threadInfo);
            bundle.putString("class_name", className);
            bundle.putString("native_info", nativeInfo);
            bundle.putString("backtrace", backtrace);
            NativeCrashHandler.setOriginBaseAppInfo(context, packageName, bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bundle;
    }

    private static String parsePackageName(String str) {
        String packageName = "";
        try {
            Pattern pattern = Pattern.compile(">>> (\\S+) <<<");
            Matcher matcher = pattern.matcher(str);
            if (matcher.find()) {
                packageName = matcher.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packageName;
    }

    private static void setOriginBaseAppInfo(Context context, String packageName, Bundle bundle) {
        String appName = null;
        String appVersion = null;
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            appVersion = String.valueOf(packageInfo.versionCode);
            ApplicationInfo info = packageManager.getApplicationInfo(packageName, 128);
            appName = packageManager.getApplicationLabel(info).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        bundle.putString("key_package_name", packageName);
        bundle.putString("key_app_name", appName);
        bundle.putString("key_app_version", appVersion);
    }
}

