/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.dropbox;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.dropbox.DropBoxHandler;
import com.ainirobot.base.dropbox.DropBoxUtil;
import com.ainirobot.base.report.DropBoxData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class JavaCrashHandler
extends DropBoxHandler {
    @Override
    String[] supportType() {
        return new String[]{"data_app_crash", "system_app_crash"};
    }

    @Override
    public DropBoxData handleInner(Context context, String fileName) {
        try {
            long fileTime = JavaCrashHandler.parseTime(fileName);
            if (fileTime == -1L) {
                Log.d((String)"Zip", (String)("data_app_crash parseTime error, fileName = " + fileName));
                return null;
            }
            String orionFileName = DropBoxUtil.getFileName(fileName);
            Throwable throwable = null;
            Bundle bundle = new Bundle();
            String crashInfo = DropBoxUtil.getInstance().getText(fileName);
            throwable = this.parseThrowableAndFillBundle(context, crashInfo, bundle);
            if (throwable != null) {
                bundle.putInt("key_collapse", 1);
                bundle.putString("key_source", "821");
                bundle.putInt("key_source_type", 2);
                bundle.putLong("key_ctime", fileTime);
                String cosUrl = DropBoxUtil.getBucketPath(orionFileName, fileTime);
                bundle.putString("key_cos_log_url", cosUrl);
                DropBoxData data = new DropBoxData();
                data.throwable = throwable;
                data.bundle = bundle;
                data.type = DropBoxData.JAVA_CRASH;
                return data;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable parseThrowableAndFillBundle(Context context, String crash, Bundle bundle) {
        Throwable throwable = null;
        try {
            Log.w((String)"Zip", (String)"----------");
            Log.w((String)"Zip", (String)"**********");
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new StringReader(crash));
                throwable = this.parseExceptionAndFillBundle(context, reader, bundle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return throwable;
    }

    private Throwable parseExceptionAndFillBundle(Context context, BufferedReader reader, Bundle bundle) throws Exception {
        String appVersion;
        String appName;
        String packageName;
        String line = null;
        line = reader.readLine();
        if (line == null) {
            return null;
        }
        String process = "Process: ";
        if (line.contains(process)) {
            packageName = line.substring(process.length());
            appName = null;
            appVersion = null;
            PackageManager packageManager = context.getPackageManager();
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
                appVersion = String.valueOf(packageInfo.versionCode);
                ApplicationInfo info = packageManager.getApplicationInfo(packageName, 128);
                appName = packageManager.getApplicationLabel(info).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            return null;
        }
        bundle.putString("key_package_name", packageName);
        bundle.putString("key_app_name", appName);
        bundle.putString("key_app_version", appVersion);
        return JavaCrashHandler.getThrowable(reader, line);
    }

    private static Throwable getThrowable(BufferedReader reader, String line) throws IOException {
        while (line != null && line.length() > 0) {
            line = reader.readLine();
        }
        if (line == null) {
            return null;
        }
        line = reader.readLine();
        if (line == null) {
            return null;
        }
        Throwable throwable = JavaCrashHandler.initThrowable(line);
        StackTraceElement[] stackTraceElements = JavaCrashHandler.getStackTraceElements(throwable, reader);
        throwable.setStackTrace(stackTraceElements);
        return throwable;
    }

    private static StackTraceElement[] getStackTraceElements(Throwable throwable, BufferedReader reader) throws IOException {
        String line;
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        while ((line = reader.readLine()) != null) {
            if (TextUtils.isEmpty((CharSequence)line)) continue;
            String cause = "Caused by: ";
            if (line.startsWith(cause)) {
                Throwable t = JavaCrashHandler.initThrowable(line.substring(cause.length()));
                StackTraceElement[] stackTraceElements = JavaCrashHandler.getStackTraceElements(t, reader);
                t.setStackTrace(stackTraceElements);
                throwable.initCause(t);
                continue;
            }
            String declaringClass = "";
            String methodName = "";
            String fileName = "";
            int lineNumber = 0;
            String at = "at ";
            int index = line.indexOf(at);
            if (index == -1) {
                declaringClass = line;
                StackTraceElement element = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
                elements.add(element);
                continue;
            }
            declaringClass = line.substring(index + at.length());
            int leftBracketIndex = declaringClass.indexOf("(");
            declaringClass = leftBracketIndex == -1 ? declaringClass : declaringClass.substring(0, leftBracketIndex);
            int lastDotIndex = declaringClass.lastIndexOf(".");
            methodName = lastDotIndex == -1 ? "" : declaringClass.substring(lastDotIndex + 1);
            declaringClass = lastDotIndex == -1 ? declaringClass : declaringClass.substring(0, lastDotIndex);
            int colonIndex = line.indexOf(":");
            int rightBracketIndex = line.lastIndexOf(")");
            if (colonIndex != -1) {
                fileName = line.substring(index + leftBracketIndex + at.length() + 1, colonIndex);
                lineNumber = Integer.parseInt(rightBracketIndex == -1 ? line.substring(colonIndex + 1) : line.substring(colonIndex + 1, rightBracketIndex));
            } else {
                fileName = rightBracketIndex == -1 ? "" : line.substring(index + leftBracketIndex + at.length() + 1, rightBracketIndex);
            }
            StackTraceElement element = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            elements.add(element);
        }
        StackTraceElement[] stackTraceElements = new StackTraceElement[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            stackTraceElements[i] = (StackTraceElement)elements.get(i);
        }
        return stackTraceElements;
    }

    private static Throwable initThrowable(String line) {
        Throwable throwable = null;
        try {
            int index = line.indexOf(": ");
            if (index == -1) {
                throwable = (Throwable)Class.forName(line).newInstance();
            } else {
                String className = line.substring(0, index);
                String message = line.substring(index + 2);
                throwable = (Throwable)Class.forName(className).newInstance();
                Field f = Throwable.class.getDeclaredField("detailMessage");
                f.setAccessible(true);
                f.set(throwable, message);
            }
            if (throwable.getCause() == null) {
                throwable = new RuntimeException(line);
            }
        }
        catch (Exception e) {
            throwable = new RuntimeException(line);
        }
        return throwable;
    }
}

