/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.dropbox;

import android.content.Context;
import android.os.DropBoxManager;
import android.text.TextUtils;
import com.ainirobot.base.ApplicationWrapper;
import com.ainirobot.base.config.Constants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DropBoxUtil {
    private static DropBoxManager mDropBoxManager;
    private static final int MAX_BYTES = 0x6400000;

    private DropBoxUtil() {
        Context context = ApplicationWrapper.getApplicationContext();
        mDropBoxManager = (DropBoxManager)context.getSystemService("dropbox");
    }

    public static final DropBoxUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public String getText(String fileName) {
        if (mDropBoxManager == null) {
            // empty if block
        }
        String text = null;
        try {
            long time = DropBoxUtil.parseTime(fileName) - 1L;
            String tag = DropBoxUtil.parseTag(fileName);
            DropBoxManager.Entry entry = mDropBoxManager.getNextEntry(tag, time);
            text = entry.getText(0x6400000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    protected static String parseTag(String fileName) {
        String tag = null;
        int index = fileName.lastIndexOf("/");
        String str = fileName.substring(index);
        Pattern pattern = Pattern.compile("[/](\\S+)@");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            tag = matcher.group(1);
        }
        return tag;
    }

    protected static long parseTime(String fileName) {
        long time = -1L;
        try {
            Pattern pattern = Pattern.compile("@(\\d+).");
            Matcher matcher = pattern.matcher(fileName);
            if (matcher.find()) {
                String value = matcher.group(1);
                time = Long.parseLong(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    public static String getBucketPath(String fileName, long timeStamp) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("/orionbase/sems/");
            if (Constants.BUILD_TYPE_UNIT_TEST) {
                builder.append("test/");
            } else {
                builder.append("formal/");
            }
            long time = String.valueOf(timeStamp).length() < 13 ? timeStamp * 1000L : timeStamp;
            String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(time));
            builder.append(date);
            builder.append("/");
            builder.append(fileName);
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknow";
        }
    }

    public static String getFileName(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        int index = filePath.lastIndexOf("/");
        String fileName = filePath.substring(index + 1);
        return fileName;
    }

    private static class SingletonHolder {
        private static final DropBoxUtil INSTANCE = new DropBoxUtil();

        private SingletonHolder() {
        }
    }
}

