/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.dropbox;

import android.content.Context;
import com.ainirobot.base.dropbox.AnrHandler;
import com.ainirobot.base.dropbox.DropBoxHandler;
import com.ainirobot.base.dropbox.DropBoxPlugin;
import com.ainirobot.base.dropbox.JavaCrashHandler;
import com.ainirobot.base.dropbox.NativeCrashHandler;
import com.ainirobot.base.report.DropBoxData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DropBoxManager {
    private static final String DROPBOX_DIR = "/data/system/dropbox/";
    private DropBoxPlugin mPlugin;
    private List<DropBoxHandler> mHandlers = new ArrayList<DropBoxHandler>();

    private DropBoxManager() {
        this.mHandlers.add(new JavaCrashHandler());
        this.mHandlers.add(new NativeCrashHandler());
        this.mHandlers.add(new AnrHandler());
    }

    public void setPlugin(DropBoxPlugin plugin) {
        this.mPlugin = plugin;
    }

    public static DropBoxManager Instance() {
        return SingletonHolder.Instance;
    }

    public void handle(Context context, String fileName) {
        DropBoxHandler handler;
        DropBoxData data = null;
        Iterator<DropBoxHandler> iterator = this.mHandlers.iterator();
        while (iterator.hasNext() && (data = (handler = iterator.next()).handle(context, DROPBOX_DIR + fileName)) == null) {
        }
        if (data != null && this.mPlugin != null) {
            this.mPlugin.handleData(data);
        }
    }

    private static class SingletonHolder {
        public static final DropBoxManager Instance = new DropBoxManager();

        private SingletonHolder() {
        }
    }
}

