/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.dropbox;

import android.content.Context;
import android.text.TextUtils;
import com.ainirobot.base.report.DropBoxData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DropBoxHandler {
    static final boolean DEBUG = true;

    public DropBoxData handle(Context context, String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        boolean isSupport = false;
        for (String type : this.supportType()) {
            if (!fileName.contains(type)) continue;
            isSupport = true;
            break;
        }
        if (!isSupport) {
            return null;
        }
        return this.handleInner(context, fileName);
    }

    abstract DropBoxData handleInner(Context var1, String var2);

    abstract String[] supportType();

    protected static long parseTime(String fileName) {
        long time = -1L;
        try {
            Pattern pattern = Pattern.compile("@(\\d+).");
            Matcher matcher = pattern.matcher(fileName);
            if (matcher.find()) {
                String value = matcher.group(1);
                time = Long.parseLong(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }
}

