/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.dropbox;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.ainirobot.base.dropbox.DropBoxHandler;
import com.ainirobot.base.dropbox.DropBoxUtil;
import com.ainirobot.base.report.DropBoxData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Scanner;

public class AnrHandler
extends DropBoxHandler {
    private static final String TEMP_SUFFIX = "_whole";

    @Override
    DropBoxData handleInner(Context context, String fileName) {
        DropBoxData data = null;
        try {
            long fileTime = AnrHandler.parseTime(fileName);
            if (fileTime == -1L) {
                Log.d((String)"Zip", (String)("data_app_crash parseTime error, fileName = " + fileName));
                return null;
            }
            String orionFileName = DropBoxUtil.getFileName(fileName);
            Bundle bundle = new Bundle();
            if ((bundle = this.parseBundle(context, fileName, bundle)) == null) {
                fileName = fileName.replace(".gz", "");
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                File tmpFile = new File(context.getFilesDir().getAbsolutePath(), fileName);
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
            String cosUrl = DropBoxUtil.getBucketPath(orionFileName, fileTime);
            bundle.putLong("key_ctime", fileTime);
            bundle.putString("key_cos_log_url", cosUrl);
            data = new DropBoxData();
            data.type = DropBoxData.ANR;
            data.bundle = bundle;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle parseBundle(Context context, String fileName, Bundle bundle) {
        ByteArrayOutputStream bout = null;
        BufferedReader reader = null;
        BufferedWriter bw = null;
        Scanner scanner = null;
        try {
            String crashInfo = DropBoxUtil.getInstance().getText(fileName);
            reader = new BufferedReader(new StringReader(crashInfo));
            scanner = new Scanner(reader);
            String line = null;
            String orionFileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            fileName = fileName.replace(".gz", "");
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            File tmpFile = new File(context.getFilesDir().getAbsolutePath(), fileName);
            bw = new BufferedWriter(new FileWriter(tmpFile));
            String process = "Process: ";
            if (scanner.hasNextLine()) {
                String appVersion;
                String appName;
                String packageName2;
                line = scanner.nextLine();
                if (line.contains(process)) {
                    packageName2 = line.substring(process.length());
                    appName = null;
                    appVersion = null;
                    PackageManager packageManager = context.getPackageManager();
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(packageName2, 0);
                        appVersion = String.valueOf(packageInfo.versionCode);
                        ApplicationInfo info = packageManager.getApplicationInfo(packageName2, 128);
                        appName = packageManager.getApplicationLabel(info).toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Bundle packageName2 = null;
                    return packageName2;
                }
                bundle.putString("key_package_name", packageName2);
                bundle.putString("key_app_name", appName);
                bundle.putString("key_app_version", appVersion);
                bundle.putString("key_anr_path", tmpFile.getAbsolutePath());
                bundle.putString("key_orion_file_name", orionFileName);
                bw.write(line + "\r\n");
            }
            String startLine = "----- pid";
            String endLine = "----- end ";
            boolean hasWriteMsg = false;
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                bw.write(line + "\r\n");
                if (line.startsWith(startLine) && !hasWriteMsg) {
                    bundle.putString("key_short_msg", line);
                    hasWriteMsg = true;
                }
                if (!line.startsWith(endLine)) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (scanner != null) {
                scanner.close();
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bundle;
    }

    @Override
    String[] supportType() {
        return new String[]{"data_app_anr"};
    }
}

