/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory.utils;

import android.os.Build;
import android.os.Debug;
import com.ainirobot.base.util.Logger;
import java.lang.reflect.Method;

public class DebugMemoryInfoUtil {
    private static Method getMemoryStatMethod = null;

    public static int getMemoryStat(String statName, Debug.MemoryInfo memoryInfo) {
        if (Build.VERSION.SDK_INT < 23) {
            return -1;
        }
        try {
            if (getMemoryStatMethod == null) {
                Class<?> ownerClass = Class.forName("android.os.Debug$MemoryInfo");
                Class[] argsClass = new Class[]{String.class};
                getMemoryStatMethod = ownerClass.getMethod("getMemoryStat", argsClass);
            }
            Object[] params = new Object[]{statName};
            return Integer.parseInt((String)getMemoryStatMethod.invoke((Object)memoryInfo, params));
        }
        catch (Exception e) {
            Logger.e(e.getMessage(), new Object[0]);
            return -1;
        }
    }

    public static int getTotalUss(Debug.MemoryInfo memoryInfo) {
        if (Build.VERSION.SDK_INT < 23) {
            return -1;
        }
        if (memoryInfo == null) {
            return -1;
        }
        return memoryInfo.dalvikPrivateDirty + memoryInfo.nativePrivateDirty + memoryInfo.otherPrivateDirty + memoryInfo.getTotalPrivateClean();
    }
}

