/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory.utils;

import com.ainirobot.base.util.DoubleUtils;
import com.ainirobot.base.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class CpuUtils {
    public static Map<String, CpuUtils> cpuInfoMap = new HashMap<String, CpuUtils>();
    private static boolean initCpu = true;
    private static double o_cpu = 0.0;
    private static double o_idle = 0.0;
    private static double p_jif = 0.0;
    private static double pCpu = 0.0;
    private static double aCpu = 0.0;
    private static double o_pCpu = 0.0;
    private static double o_aCpu = 0.0;

    public long getJif() {
        return (long)p_jif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getCpuUsage() {
        double usage;
        block12: {
            block13: {
                usage = 0.0;
                if (!initCpu) break block13;
                initCpu = false;
                RandomAccessFile reader = null;
                try {
                    reader = new RandomAccessFile("/proc/stat", "r");
                    String load = reader.readLine();
                    String[] toks = load.split(" ");
                    o_idle = Double.parseDouble(toks[5]);
                    o_cpu = Double.parseDouble(toks[2]) + Double.parseDouble(toks[3]) + Double.parseDouble(toks[4]) + Double.parseDouble(toks[6]) + Double.parseDouble(toks[8]) + Double.parseDouble(toks[7]);
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeRandomAccessFile(reader);
                        throw throwable;
                    }
                    FileUtils.closeRandomAccessFile(reader);
                    break block12;
                }
                FileUtils.closeRandomAccessFile(reader);
                break block12;
            }
            RandomAccessFile reader = null;
            try {
                reader = new RandomAccessFile("/proc/stat", "r");
                String load = reader.readLine();
                String[] toks = load.split(" ");
                double c_idle = Double.parseDouble(toks[5]);
                double c_cpu = Double.parseDouble(toks[2]) + Double.parseDouble(toks[3]) + Double.parseDouble(toks[4]) + Double.parseDouble(toks[6]) + Double.parseDouble(toks[8]) + Double.parseDouble(toks[7]);
                if (0.0 != c_cpu + c_idle - (o_cpu + o_idle)) {
                    usage = DoubleUtils.div(100.0 * (c_cpu - o_cpu), c_cpu + c_idle - (o_cpu + o_idle), 2);
                    if (usage < 0.0) {
                        usage = 0.0;
                    } else if (usage > 100.0) {
                        usage = 100.0;
                    }
                }
                o_cpu = c_cpu;
                o_idle = c_idle;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtils.closeRandomAccessFile(reader);
                    throw throwable;
                }
                FileUtils.closeRandomAccessFile(reader);
            }
            FileUtils.closeRandomAccessFile(reader);
        }
        return usage;
    }

    public static double getCpuUsage0() {
        try {
            RandomAccessFile reader = new RandomAccessFile("/proc/stat", "r");
            String load = reader.readLine();
            String[] toks = load.split(" ");
            double idle1 = Double.parseDouble(toks[5]);
            double cpu1 = Double.parseDouble(toks[2]) + Double.parseDouble(toks[3]) + Double.parseDouble(toks[4]) + Double.parseDouble(toks[6]) + Double.parseDouble(toks[8]) + Double.parseDouble(toks[7]);
            try {
                Thread.sleep(360L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            reader.seek(0L);
            load = reader.readLine();
            reader.close();
            toks = load.split(" ");
            double idle2 = Double.parseDouble(toks[5]);
            double cpu2 = Double.parseDouble(toks[2]) + Double.parseDouble(toks[3]) + Double.parseDouble(toks[4]) + Double.parseDouble(toks[6]) + Double.parseDouble(toks[8]) + Double.parseDouble(toks[7]);
            double value = DoubleUtils.div(100.0 * (cpu2 - cpu1), cpu2 + idle2 - (cpu1 + idle1), 2);
            return value;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public static double getCpuUsage1() {
        try {
            RandomAccessFile reader = new RandomAccessFile("/proc/stat", "r");
            String load = reader.readLine();
            String[] toks = load.split(" ");
            double user1 = Double.parseDouble(toks[2]);
            double system1 = Double.parseDouble(toks[4]);
            double irq1 = Double.parseDouble(toks[7]);
            double idle1 = Double.parseDouble(toks[5]);
            try {
                Thread.sleep(360L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            reader.seek(0L);
            load = reader.readLine();
            reader.close();
            toks = load.split(" ");
            double user2 = Double.parseDouble(toks[2]);
            double system2 = Double.parseDouble(toks[4]);
            double irq2 = Double.parseDouble(toks[7]);
            double idle2 = Double.parseDouble(toks[5]);
            double user_pass = user2 - user1;
            double system_pass = system2 - system1;
            double irq_pass = irq2 - irq1;
            double idle_pass = idle2 - idle1;
            double usage = (user_pass + system_pass + irq_pass) * 100.0 / (user_pass + irq_pass + system_pass + idle_pass);
            BigDecimal b = new BigDecimal(usage);
            double res = b.setScale(2, 4).doubleValue();
            return res;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return 0.0;
    }

    public static String[] getProcessCpuAction(int pid) {
        String cpuPath = "/proc/" + pid + "/stat";
        String cpu = "";
        String[] result = new String[3];
        File f = new File(cpuPath);
        if (!f.exists() || !f.canRead()) {
            return result;
        }
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        try {
            fr = new FileReader(f);
            localBufferedReader = new BufferedReader(fr, 8192);
            cpu = localBufferedReader.readLine();
            if (null != cpu) {
                String[] cpuSplit = cpu.split(" ");
                result[0] = cpuSplit[1];
                result[1] = cpuSplit[13];
                result[2] = cpuSplit[14];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileUtils.closeReader(localBufferedReader);
        return result;
    }

    public static String[] getCpuAction() {
        String cpuPath = "/proc/stat";
        String cpu = "";
        String[] result = new String[7];
        File f = new File(cpuPath);
        if (!f.exists() || !f.canRead()) {
            return result;
        }
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        try {
            fr = new FileReader(f);
            localBufferedReader = new BufferedReader(fr, 8192);
            cpu = localBufferedReader.readLine();
            if (null != cpu) {
                result = cpu.split(" ");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileUtils.closeReader(localBufferedReader);
        return result;
    }

    public CpuUtils() {
        this.initCpuData();
    }

    private void initCpuData() {
        o_pCpu = 0.0;
        pCpu = 0.0;
        o_aCpu = 0.0;
        aCpu = 0.0;
    }

    public static double getProcessCpuUsage(int pid) {
        double result = 0.0;
        String[] result1 = null;
        String[] result2 = null;
        if (pid >= 0) {
            result1 = CpuUtils.getProcessCpuAction(pid);
            if (null != result1) {
                pCpu = Double.parseDouble(result1[1]) + Double.parseDouble(result1[2]);
            }
            if (null != (result2 = CpuUtils.getCpuAction())) {
                aCpu = 0.0;
                for (int i = 2; i < result2.length; ++i) {
                    aCpu += Double.parseDouble(result2[i]);
                }
            }
            double usage = 0.0;
            if (aCpu - o_aCpu != 0.0) {
                usage = DoubleUtils.div((pCpu - o_pCpu) * 100.0, aCpu - o_aCpu, 2);
                if (usage < 0.0) {
                    usage = 0.0;
                } else if (usage > 100.0) {
                    usage = 100.0;
                }
            }
            o_pCpu = pCpu;
            o_aCpu = aCpu;
            result = usage;
        }
        p_jif = pCpu;
        return result;
    }

    public static void getCpuUsageByCmd() {
        StringBuilder sb = new StringBuilder();
        String line = "";
        String cmd = "dumpsys cpuinfo";
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd});
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                sb.append(line);
                sb.append("\r\n");
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

