/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory.utils;

import android.util.Log;
import com.ainirobot.base.util.DeviceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONArray;
import org.json.JSONObject;

public class CpuFrequency {
    private static final String[] NAME_ARRAY_821 = new String[]{"cpu0", "cpu1", "cpu2", "cpu3"};
    private static final String[] NAME_ARRAY_845 = new String[]{"cpu0", "cpu1", "cpu2", "cpu3", "cpu4", "cpu5", "cpu6", "cpu7"};
    private static final String[] PATH_ARRAY_821 = new String[]{"/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq"};
    private static final String[] PATH_ARRAY_845 = new String[]{"/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu4/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu5/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu6/cpufreq/scaling_cur_freq", "/sys/devices/system/cpu/cpu7/cpufreq/scaling_cur_freq"};

    public static JSONObject getCpuFrequency() {
        String[] nameArray = null;
        String[] pathArray = null;
        int cores = DeviceUtil.getNumOfCores();
        if (cores == 4) {
            nameArray = NAME_ARRAY_821;
            pathArray = PATH_ARRAY_821;
        } else if (cores == 8) {
            nameArray = NAME_ARRAY_845;
            pathArray = PATH_ARRAY_845;
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < pathArray.length; ++i) {
                String path = pathArray[i];
                int frequency = CpuFrequency.getItemFrequency(path);
                JSONObject freqJSON = new JSONObject();
                freqJSON.put("name", (Object)nameArray[i]);
                freqJSON.put("freq", frequency);
                jsonArray.put((Object)freqJSON);
            }
            jsonObject.put("ctime", System.currentTimeMillis());
            jsonObject.put("cpu_info", (Object)jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getItemFrequency(String path) {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cat " + path);
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            String line = br.readLine();
            if (null != line) {
                int n = Integer.parseInt(line);
                return n;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.w((String)"OrionBase", (String)("*** getItemFrequency ERROR *** : " + e.getMessage()));
        }
        catch (NumberFormatException ne) {
            ne.printStackTrace();
            Log.w((String)"OrionBase", (String)("*** getItemFrequency FORMAT ERROR *** : " + ne.getMessage()));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }
}

