/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory.utils;

import android.util.Log;
import com.ainirobot.base.util.DeviceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONArray;
import org.json.JSONObject;

public class CPUTemperatureInfo {
    public static final String[] NAME_ARRAY_821 = new String[]{"memory", "cpu0", "cpu1", "cpu2", "cpu3", "gpu"};
    public static final String[] NAME_ARRAY_845 = new String[]{"memory", "cpu0", "cpu1", "cpu2", "cpu3", "cpu4", "cpu5", "cpu6", "cpu7", "gpu0", "gpu1"};
    public static final String[] PATH_ARRAY_821 = new String[]{"sys/class/thermal/thermal_zone2/temp", "sys/class/thermal/thermal_zone5/temp", "sys/class/thermal/thermal_zone7/temp", "sys/class/thermal/thermal_zone10/temp", "sys/class/thermal/thermal_zone12/temp", "sys/class/thermal/thermal_zone16/temp"};
    public static final String[] PATH_ARRAY_845 = new String[]{"sys/class/thermal/thermal_zone24/temp", "sys/class/thermal/thermal_zone38/temp", "sys/class/thermal/thermal_zone39/temp", "sys/class/thermal/thermal_zone40/temp", "sys/class/thermal/thermal_zone41/temp", "sys/class/thermal/thermal_zone44/temp", "sys/class/thermal/thermal_zone45/temp", "sys/class/thermal/thermal_zone46/temp", "sys/class/thermal/thermal_zone47/temp", "sys/class/thermal/thermal_zone48/temp", "sys/class/thermal/thermal_zone49/temp"};

    public static JSONObject getTemperature() {
        String[] nameArray = null;
        String[] pathArray = null;
        int cores = DeviceUtil.getNumOfCores();
        if (cores == 4) {
            nameArray = NAME_ARRAY_821;
            pathArray = PATH_ARRAY_821;
        } else if (cores == 8) {
            nameArray = NAME_ARRAY_845;
            pathArray = PATH_ARRAY_845;
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < pathArray.length; ++i) {
                String path = pathArray[i];
                int temp = CPUTemperatureInfo.getItemTemperature(path, cores);
                JSONObject tempJson = new JSONObject();
                tempJson.put("name", (Object)nameArray[i]);
                tempJson.put("temp", temp);
                jsonArray.put((Object)tempJson);
            }
            jsonObject.put("ctime", System.currentTimeMillis());
            jsonObject.put("cpu_info", (Object)jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getItemTemperature(String path, int cores) {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cat " + path);
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while (null != (line = br.readLine())) {
                if (cores == 4) {
                    int n = Integer.parseInt(line) / 10;
                    return n;
                }
                if (cores != 8) continue;
                int n = Integer.parseInt(line) / 1000;
                return n;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.w((String)"OrionBase", (String)("*** getItemTemperature ERROR *** : " + e.getMessage()));
        }
        catch (NumberFormatException ne) {
            ne.printStackTrace();
            Log.w((String)"OrionBase", (String)("*** getItemTemperature FORMAT ERROR *** : " + ne.getMessage()));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }
}

