/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory.core;

import android.content.Context;
import android.os.Debug;
import android.os.Handler;
import android.util.Log;
import com.ainirobot.base.cpumemory.core.CPUMemoryCanaryCore;
import com.ainirobot.base.cpumemory.utils.CpuUtils;
import com.ainirobot.base.cpumemory.utils.DebugMemoryInfoUtil;
import com.ainirobot.base.listener.ICpuWarnListener;
import com.ainirobot.base.listener.IMemoryWarnListener;
import com.ainirobot.base.util.DeviceUtil;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.OrionBaseHandlerThread;
import java.util.Map;
import java.util.TreeMap;

public class SingleProcessWarn {
    private static final String TAG = CPUMemoryCanaryCore.class.getSimpleName();
    private static final String TOTAL_PSS = "summary.total-pss";
    private static final int NONE = -1;
    private final Handler mHandler;
    private final Context mContext;
    private ICpuWarnListener mCpuCallback;
    private IMemoryWarnListener mMemoryCallback;
    private Map<Integer, Integer> mCPUWarnCount = new TreeMap<Integer, Integer>();
    private Map<Integer, Integer> mMemoryWarnCount = new TreeMap<Integer, Integer>();
    private String mProcessName;
    private int[] mCPUWarnThreshold;
    private int[] mMemoryWarnThreshold;
    private int mMemoryWarnSampleCount = -1;
    private int mCpuWarnSampleCount = -1;
    private long mMemoryWarnSampleRate = -1L;
    private long mCpuWarnSampleRate = -1L;

    public SingleProcessWarn(Context context) {
        this.mHandler = new Handler(OrionBaseHandlerThread.getDefaultHandlerThread().getLooper());
        this.mContext = context;
    }

    public void startCpuWarn() {
        if (this.mCpuCallback != null) {
            this.initCpuWarnCount();
            this.detectAppCpuInfo();
        }
    }

    public void startMemoryWarn() {
        if (this.mMemoryCallback != null) {
            this.initMemoryWarnCount();
            this.detectAppMemoryInfo();
        }
    }

    public void stop() {
        Logger.d("stop cpu memory core", new Exception());
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public void setProcessName(String processName) {
        this.mProcessName = processName;
    }

    private String getProcessName() {
        return this.mProcessName;
    }

    public void setCpuWarnSampleRate(long cpuWarnSampleRate) {
        this.mCpuWarnSampleRate = cpuWarnSampleRate;
    }

    private long getCpuWarnSampleRate() {
        return this.mCpuWarnSampleRate;
    }

    public void setMemoryWarnSampleRate(long memoryWarnSampleRate) {
        this.mMemoryWarnSampleRate = memoryWarnSampleRate;
    }

    private long getMemoryWarnSampleRate() {
        return this.mMemoryWarnSampleRate;
    }

    public void setCPUWarnThreshold(int[] cpuWarnThreshold) {
        this.mCPUWarnThreshold = cpuWarnThreshold;
    }

    private int[] getCPUWarnThreshold() {
        return this.mCPUWarnThreshold;
    }

    public void setMemoryWarnThreshold(int[] memoryWarnThreshold) {
        this.mMemoryWarnThreshold = memoryWarnThreshold;
    }

    private int[] getMemoryWarnThreshold() {
        return this.mMemoryWarnThreshold;
    }

    public void setCpuWarnSampleCount(int cpuWarnSampleCount) {
        this.mCpuWarnSampleCount = cpuWarnSampleCount;
    }

    private int getCpuWarnSampleCount() {
        return this.mCpuWarnSampleCount;
    }

    public void setMemoryWarnSampleCount(int memoryWarnSampleCount) {
        this.mMemoryWarnSampleCount = memoryWarnSampleCount;
    }

    private int getMemoryWarnSampleCount() {
        return this.mMemoryWarnSampleCount;
    }

    private void detectAppCpuInfo() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SingleProcessWarn.this.mCpuCallback != null) {
                    try {
                        SingleProcessWarn.this.detectProcessCpuInfoImpl();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SingleProcessWarn.this.detectAppCpuInfo();
            }
        }, this.getCpuWarnSampleRate());
    }

    private void detectAppMemoryInfo() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SingleProcessWarn.this.mMemoryCallback != null) {
                    try {
                        SingleProcessWarn.this.detectProcessMemoryInfoImpl();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SingleProcessWarn.this.detectAppMemoryInfo();
            }
        }, this.getMemoryWarnSampleRate());
    }

    private void detectProcessMemoryInfoImpl() {
        try {
            int value;
            String processName = this.getProcessName();
            Debug.MemoryInfo memoryInfo = DeviceUtil.getProcessMemory(this.mContext, processName);
            int totalUss = DebugMemoryInfoUtil.getTotalUss(memoryInfo);
            if (this.mMemoryCallback == null) {
                Log.i((String)"OrionBase", (String)"mMemoryCallback == null");
                return;
            }
            if (this.mMemoryWarnCount == null) {
                Log.i((String)"OrionBase", (String)"mMemoryWarnCount == null");
                return;
            }
            if (this.mMemoryWarnCount.size() <= 0) {
                return;
            }
            Log.i((String)"OrionBase", (String)("mMemoryWarnCount = " + this.mMemoryWarnCount));
            int[] ints = this.getMemoryWarnThreshold();
            if (ints == null) {
                return;
            }
            int warningValue = this.findWarnValue(totalUss, ints);
            if (warningValue > 0 && this.mMemoryWarnCount.containsKey(warningValue) && (value = this.mMemoryWarnCount.get(warningValue).intValue()) > 0) {
                this.mMemoryWarnCount.put(warningValue, --value);
                if (value == 1) {
                    int pid = DeviceUtil.getProcessIdByName(this.mContext, processName);
                    double cpu = pid == -1 ? -1.0 : CpuUtils.getProcessCpuUsage(pid);
                    this.mMemoryCallback.memoryWarn(warningValue, totalUss, cpu);
                    this.mMemoryCallback.memoryWarn(processName, warningValue, totalUss, cpu);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void detectProcessCpuInfoImpl() {
        try {
            int value;
            String processName = this.getProcessName();
            int pid = DeviceUtil.getProcessIdByName(this.mContext, processName);
            if (pid == -1) {
                return;
            }
            double cpuWarning = CpuUtils.getProcessCpuUsage(pid);
            if (this.mCpuCallback == null) {
                Log.i((String)"OrionBase", (String)"mCpuCallback == null");
                return;
            }
            if (this.mCPUWarnCount == null) {
                Log.i((String)"OrionBase", (String)"mCPUWarnCount == null");
                return;
            }
            if (this.mCPUWarnCount.size() <= 0) {
                return;
            }
            Log.i((String)"OrionBase", (String)("mCPUWarnCount = " + this.mCPUWarnCount));
            int[] ints = this.getCPUWarnThreshold();
            if (ints == null) {
                return;
            }
            int warningValue = this.findWarnValue(cpuWarning, ints);
            if (warningValue > 0 && this.mCPUWarnCount.containsKey(warningValue) && (value = this.mCPUWarnCount.get(warningValue).intValue()) > 0) {
                this.mCPUWarnCount.put(warningValue, --value);
                if (value == 1) {
                    Debug.MemoryInfo memoryInfo = DeviceUtil.getProcessMemory(this.mContext, processName);
                    int totalUss = DebugMemoryInfoUtil.getTotalUss(memoryInfo);
                    this.mCpuCallback.cpuWarn(warningValue, cpuWarning, totalUss);
                    this.mCpuCallback.cpuWarn(processName, warningValue, cpuWarning, totalUss);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int findWarnValue(double cpuWarning, int[] warningValues) {
        int warningValue = -1;
        int[] sortWarningValues = this.bubbleSort(warningValues);
        if (cpuWarning < (double)sortWarningValues[0]) {
            return warningValue;
        }
        if (cpuWarning > (double)sortWarningValues[sortWarningValues.length - 1]) {
            warningValue = sortWarningValues[sortWarningValues.length - 1];
        } else {
            for (int i = 0; i < sortWarningValues.length - 1; ++i) {
                if (!(cpuWarning >= (double)sortWarningValues[i]) || !(cpuWarning < (double)sortWarningValues[i + 1])) continue;
                warningValue = sortWarningValues[i];
            }
        }
        return warningValue;
    }

    private int[] bubbleSort(int[] arr) {
        int len = arr.length;
        for (int i = 0; i < len - 1; ++i) {
            for (int j = 0; j < len - 1 - i; ++j) {
                if (arr[j] <= arr[j + 1]) continue;
                int temp = arr[j + 1];
                arr[j + 1] = arr[j];
                arr[j] = temp;
            }
        }
        return arr;
    }

    public void setCpuCallback(ICpuWarnListener callback) {
        this.mCpuCallback = callback;
    }

    public void setMemoryCallback(IMemoryWarnListener callback) {
        this.mMemoryCallback = callback;
    }

    public void resetCPUMemoryWarnCount() {
        Log.i((String)"OrionBase", (String)"resetCPUMemoryWarnCount");
        this.mHandler.removeCallbacksAndMessages(null);
        this.initMemoryWarnCount();
        this.initCpuWarnCount();
        this.startMemoryWarn();
        this.startCpuWarn();
    }

    private void initCpuWarnCount() {
        this.mCPUWarnCount.clear();
        int cpuWarnCount = this.getCpuWarnSampleCount() + 1;
        int[] cpuThreshold = this.getCPUWarnThreshold();
        if (cpuThreshold != null) {
            for (int i : cpuThreshold) {
                this.mCPUWarnCount.put(i, cpuWarnCount);
            }
        }
    }

    private void initMemoryWarnCount() {
        this.mMemoryWarnCount.clear();
        int memoryWarnCount = this.getMemoryWarnSampleCount() + 1;
        int[] memoryThreshold = this.getMemoryWarnThreshold();
        if (memoryThreshold != null) {
            for (int i : memoryThreshold) {
                this.mMemoryWarnCount.put(i, memoryWarnCount);
            }
        }
    }
}

