/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory.core;

import android.content.Context;
import android.os.Debug;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.StatFs;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.cpumemory.aidl.ICpuFreMonitorCallback;
import com.ainirobot.base.cpumemory.aidl.ITempMonitorCallback;
import com.ainirobot.base.cpumemory.config.SharePluginInfo;
import com.ainirobot.base.cpumemory.core.CPUMemoryCanaryCore;
import com.ainirobot.base.cpumemory.utils.CPUTemperatureInfo;
import com.ainirobot.base.cpumemory.utils.CpuFrequency;
import com.ainirobot.base.plugin.PluginHandler;
import com.ainirobot.base.report.ReportData;
import com.ainirobot.base.util.DeviceUtil;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.ShellUtils;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class CPUMemoryReportCanaryCore {
    private static final String TAG = CPUMemoryCanaryCore.class.getSimpleName();
    private Handler mHandler;
    private Context mContext;
    private PluginHandler mPluginHandler;
    private HandlerThread mHandlerThread;
    private ITempMonitorCallback mTempMonitorCallback;
    private ICpuFreMonitorCallback mCpuFreMonitorCallback;

    private CPUMemoryReportCanaryCore() {
    }

    public static CPUMemoryReportCanaryCore getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized void init(Context context) {
        this.mHandlerThread = new HandlerThread("cpuMemory.report.thread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mContext = context;
    }

    public void start() {
        this.detectAppInfo(300000L);
        this.detectCPUInfo(420000L);
        this.detectStorage(540000L);
    }

    public void stop() {
        Logger.d("stop cpu memory core", new Exception());
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandlerThread.quit();
    }

    private void detectAppInfo(long delayTime) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CPUMemoryReportCanaryCore.this.mPluginHandler != null) {
                        JSONObject memoryJson;
                        JSONObject cpuJson;
                        JSONObject gpuJson = DumpsysCpuCMD.getGpuJsonObject();
                        if (gpuJson != null) {
                            Log.e((String)"OrionBase", (String)("detectAppInfo gpuJson = " + gpuJson.toString()));
                            if (!Constants.ENABLE_DOMAIN_GLOBAL) {
                                ReportData reportData = new ReportData();
                                reportData.type = 11;
                                reportData.data = new JSONObject(gpuJson.toString());
                                CPUMemoryReportCanaryCore.this.mPluginHandler.handleData(reportData);
                            }
                        }
                        if ((cpuJson = DumpsysCpuCMD.getCpuJsonObject()) != null) {
                            Log.i((String)"OrionBase", (String)("detectAppInfo cpuJson = " + cpuJson.toString()));
                            if (!Constants.ENABLE_DOMAIN_GLOBAL) {
                                ReportData reportData = new ReportData();
                                reportData.type = 6;
                                reportData.data = new JSONObject(cpuJson.toString());
                                CPUMemoryReportCanaryCore.this.mPluginHandler.handleData(reportData);
                            }
                        }
                        if ((memoryJson = DumpsysMemCMD.getMemoryJsonObject(CPUMemoryReportCanaryCore.this.mContext)) != null) {
                            Log.i((String)"OrionBase", (String)("detectAppInfo memoryJson = " + memoryJson.toString()));
                            if (!Constants.ENABLE_DOMAIN_GLOBAL) {
                                ReportData reportData = new ReportData();
                                reportData.type = 7;
                                reportData.data = new JSONObject(memoryJson.toString());
                                CPUMemoryReportCanaryCore.this.mPluginHandler.handleData(reportData);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CPUMemoryReportCanaryCore.this.detectAppInfo(300000L);
            }
        }, delayTime);
    }

    private void detectCPUInfo(long delayTime) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject tempJson = CPUTemperatureInfo.getTemperature();
                    Log.i((String)"OrionBase", (String)("detectTemperature json = " + tempJson.toString()));
                    if (CPUMemoryReportCanaryCore.this.mPluginHandler != null && tempJson != null && !Constants.ENABLE_DOMAIN_GLOBAL) {
                        if (CPUMemoryReportCanaryCore.this.mTempMonitorCallback != null) {
                            CPUMemoryReportCanaryCore.this.mTempMonitorCallback.tempMonitor(tempJson.toString());
                        }
                        ReportData reportData = new ReportData();
                        reportData.type = 8;
                        reportData.data = new JSONObject(tempJson.toString());
                        CPUMemoryReportCanaryCore.this.mPluginHandler.handleData(reportData);
                    }
                    JSONObject cpuFrequencyJson = CpuFrequency.getCpuFrequency();
                    Log.i((String)"OrionBase", (String)("detectCpuFrequency json = " + cpuFrequencyJson.toString()));
                    if (CPUMemoryReportCanaryCore.this.mPluginHandler != null && cpuFrequencyJson != null && !Constants.ENABLE_DOMAIN_GLOBAL) {
                        if (CPUMemoryReportCanaryCore.this.mCpuFreMonitorCallback != null) {
                            CPUMemoryReportCanaryCore.this.mCpuFreMonitorCallback.cpuFreMonitor(cpuFrequencyJson.toString());
                        }
                        ReportData reportData = new ReportData();
                        reportData.type = 10;
                        reportData.data = new JSONObject(cpuFrequencyJson.toString());
                        CPUMemoryReportCanaryCore.this.mPluginHandler.handleData(reportData);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CPUMemoryReportCanaryCore.this.detectCPUInfo(300000L);
            }
        }, delayTime);
    }

    private void detectStorage(long delayTime) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    File path = Environment.getExternalStorageDirectory();
                    StatFs statfs = new StatFs(path.getPath());
                    int availableSize = DeviceUtil.getAvailableSize(statfs);
                    int totalSize = DeviceUtil.getTotalSize(statfs);
                    JSONObject storageJson = new JSONObject();
                    storageJson.put("ctime", System.currentTimeMillis());
                    storageJson.put("available", availableSize);
                    storageJson.put("total", totalSize);
                    Log.i((String)TAG, (String)(" sdcard storage = " + storageJson.toString()));
                    if (CPUMemoryReportCanaryCore.this.mPluginHandler != null && storageJson != null && !Constants.ENABLE_DOMAIN_GLOBAL) {
                        ReportData reportData = new ReportData();
                        reportData.type = 9;
                        reportData.data = new JSONObject(storageJson.toString());
                        CPUMemoryReportCanaryCore.this.mPluginHandler.handleData(reportData);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CPUMemoryReportCanaryCore.this.detectStorage(1800000L);
            }
        }, delayTime);
    }

    public void setPluginHandler(PluginHandler handler) {
        this.mPluginHandler = handler;
    }

    public void setCpuFreMonitorListener(ICpuFreMonitorCallback cpuFreMonitorCallback) {
        this.mCpuFreMonitorCallback = cpuFreMonitorCallback;
    }

    public void setTempMonitorCallback(ITempMonitorCallback TempMonitorCallback) {
        this.mTempMonitorCallback = TempMonitorCallback;
    }

    static class TopCMD {
        TopCMD() {
        }

        private static JSONObject getCpuJsonObject() {
            try {
                String[] data;
                ShellUtils.CommandResult result = ShellUtils.execCommand("top -m 20 -n 1", false);
                if (result != null && result.successMsg != null && (data = result.successMsg.split("\n")) != null && data.length > 5) {
                    String info;
                    int rate;
                    JSONObject cpuReportData = new JSONObject();
                    JSONArray cpuJsonArray = new JSONArray();
                    int total = TopCMD.getTotalCpu(data[0]);
                    for (int i = 4; i < data.length && (rate = Integer.parseInt(TopCMD.getRate(info = data[i]))) != 0; ++i) {
                        JSONObject cpuJsonObject = new JSONObject();
                        cpuJsonObject.put("pid_cpu", (Object)TopCMD.getPidName(info));
                        cpuJsonObject.put("ratio", (Object)TopCMD.getRate(info));
                        cpuJsonArray.put((Object)cpuJsonObject);
                    }
                    long cTime = System.currentTimeMillis();
                    cpuReportData.put("ctime", (Object)String.valueOf(cTime));
                    cpuReportData.put("cpu_info", (Object)cpuJsonArray);
                    cpuReportData.put("total", (Object)String.valueOf(total));
                    return cpuReportData;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private static int getTotalCpu(String info) {
            int total = 0;
            try {
                Pattern pattern = Pattern.compile("\\D*(\\d+)\\D*");
                Matcher matcher = pattern.matcher(info);
                int user = 0;
                int system = 0;
                if (matcher.find()) {
                    user = Integer.parseInt(matcher.group(1));
                }
                if (matcher.find()) {
                    system = Integer.parseInt(matcher.group(1));
                }
                total = user + system;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return total;
        }

        private static String getRate(String info) {
            String rate = "";
            try {
                Pattern pattern = Pattern.compile(" (\\d+)% ");
                Matcher matcher = pattern.matcher(info);
                if (matcher.find()) {
                    rate = matcher.group(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return rate;
        }

        private static String getPidName(String info) {
            String pidName = "";
            try {
                Pattern pattern = Pattern.compile(" (\\S+)$");
                Matcher matcher = pattern.matcher(info);
                if (matcher.find()) {
                    pidName = matcher.group(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return pidName;
        }
    }

    public static class DumpsysCpuCMD {
        public static JSONObject getCpuJsonObject() {
            try {
                String[] data;
                ShellUtils.CommandResult result = ShellUtils.execCommand("dumpsys cpuinfo", false);
                if (result != null && result.successMsg != null && (data = result.successMsg.split("\n")) != null && data.length > 3) {
                    String info;
                    float rate;
                    JSONObject cpuReportData = new JSONObject();
                    JSONArray cpuJsonArray = new JSONArray();
                    for (int i = 2; i < data.length && (rate = DumpsysCpuCMD.getRate(info = data[i])) != 0.0f; ++i) {
                        JSONObject cpuJsonObject = new JSONObject();
                        cpuJsonObject.put("pid_cpu", (Object)DumpsysCpuCMD.getPidName(info));
                        cpuJsonObject.put("ratio", (Object)String.valueOf(rate));
                        cpuJsonArray.put((Object)cpuJsonObject);
                    }
                    long cTime = System.currentTimeMillis();
                    cpuReportData.put("ctime", (Object)String.valueOf(cTime));
                    cpuReportData.put("cpu_info", (Object)cpuJsonArray);
                    float total = DumpsysCpuCMD.getTotal(data[data.length - 1]);
                    cpuReportData.put("total", (Object)String.valueOf(total));
                    return cpuReportData;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static JSONObject getGpuJsonObject() {
            try {
                ShellUtils.CommandResult result = ShellUtils.execCommand("cat /sys/kernel/gpu/gpu_busy", false);
                if (result != null && result.successMsg != null) {
                    String gpuUsage = result.successMsg;
                    JSONObject gpuReportData = new JSONObject();
                    JSONArray gpuJsonArray = new JSONArray();
                    JSONObject gpuJsonObject = new JSONObject();
                    gpuJsonObject.put("name", (Object)"gpu");
                    gpuJsonObject.put("usage", (Object)result.successMsg.substring(0, gpuUsage.indexOf(" ")));
                    gpuJsonArray.put((Object)gpuJsonObject);
                    long cTime = System.currentTimeMillis();
                    gpuReportData.put("ctime", (Object)String.valueOf(cTime));
                    gpuReportData.put("gpu", (Object)gpuJsonArray);
                    return gpuReportData;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static float getRate(String info) {
            float rate = 0.0f;
            try {
                Pattern pattern = Pattern.compile(" (\\d*\\.*\\d*)% ");
                Matcher matcher = pattern.matcher(info);
                if (matcher.find()) {
                    rate = Float.parseFloat(matcher.group(1));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return rate;
        }

        public static String getPidName(String info) {
            String pidName = "";
            try {
                Pattern pattern = Pattern.compile("\\d+[\\/](\\S+): ");
                Matcher matcher = pattern.matcher(info);
                if (matcher.find()) {
                    pidName = matcher.group(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return pidName;
        }

        public static float getTotal(String info) {
            float total = 0.0f;
            try {
                Pattern pattern = Pattern.compile("(\\d*\\.*\\d*)% TOTAL");
                Matcher matcher = pattern.matcher(info);
                if (matcher.find()) {
                    total = Float.parseFloat(matcher.group(1));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return total;
        }
    }

    static class DumpsysMemCMD {
        DumpsysMemCMD() {
        }

        private static JSONObject getMemoryJsonObject(Context context) {
            block7: {
                try {
                    String[] data;
                    ShellUtils.CommandResult result = ShellUtils.execCommand("dumpsys meminfo", false);
                    if (result == null || result.successMsg == null || (data = result.successMsg.split("\n")) == null || data.length <= 5) break block7;
                    JSONObject memoryReportData = new JSONObject();
                    JSONArray memoryJsonArray = new JSONArray();
                    List<String> whiteList = SharePluginInfo.PROCESS_WHITE_LIST;
                    int count = 0;
                    long totalMem = 0L;
                    for (int i = 4; i < data.length; ++i) {
                        int pid;
                        ++count;
                        String info = data[i];
                        String pidName = DumpsysMemCMD.getTopMemPidName(info);
                        if (TextUtils.isEmpty((CharSequence)info)) break;
                        try {
                            pid = Integer.parseInt(DumpsysMemCMD.getTopMemPid(info));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        boolean toAdd = false;
                        if (whiteList.contains(pidName) || count <= 10) {
                            toAdd = true;
                        }
                        Debug.MemoryInfo memoryInfo = DeviceUtil.getAppMemory(context, pid);
                        int appUss = memoryInfo.getTotalPss();
                        if (toAdd && appUss > 0) {
                            JSONObject memoryJsonObject = new JSONObject();
                            memoryJsonObject.put("pid_memory", (Object)pidName);
                            memoryJsonObject.put("app_size", (Object)String.valueOf(appUss));
                            memoryJsonArray.put((Object)memoryJsonObject);
                        }
                        totalMem += (long)appUss;
                    }
                    long cTime = System.currentTimeMillis();
                    memoryReportData.put("ctime", (Object)String.valueOf(cTime));
                    memoryReportData.put("memory_info", (Object)memoryJsonArray);
                    memoryReportData.put("total", (Object)String.valueOf(totalMem));
                    Log.e((String)"david", (String)("totalMem = " + totalMem));
                    return memoryReportData;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        private static long getTotal(String info) {
            long total = 0L;
            try {
                Pattern pattern = Pattern.compile("([\\d,]*)K");
                Matcher matcher = pattern.matcher(info);
                if (matcher.find()) {
                    String value = matcher.group(1);
                    value = value.replace(",", "");
                    total = Long.parseLong(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return total;
        }

        private static String getTopMemPid(String info) {
            String pid = "";
            try {
                Pattern pattern = Pattern.compile("pid (\\d+)");
                Matcher matcher = pattern.matcher(info);
                if (matcher.find()) {
                    pid = matcher.group(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return pid;
        }

        private static String getTopMemPidName(String info) {
            String pidName = "";
            try {
                Pattern pattern = Pattern.compile(": (\\S+) [(]");
                Matcher matcher = pattern.matcher(info);
                if (matcher.find()) {
                    pidName = matcher.group(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return pidName;
        }
    }

    private static class SingletonHolder {
        private static final CPUMemoryReportCanaryCore INSTANCE = new CPUMemoryReportCanaryCore();

        private SingletonHolder() {
        }
    }
}

