/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory.core;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.config.WarnConfig;
import com.ainirobot.base.cpumemory.config.CPUMemoryConfig;
import com.ainirobot.base.cpumemory.core.SingleProcessWarn;
import com.ainirobot.base.listener.ICpuWarnListener;
import com.ainirobot.base.listener.IMemoryWarnListener;
import com.ainirobot.base.util.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CPUMemoryCanaryCore {
    private static final String TAG = CPUMemoryCanaryCore.class.getSimpleName();
    private static final String TOTAL_PSS = "summary.total-pss";
    private static final int DEFAULT_WARN_COUNT = -1;
    private static final long DEFAULT_WARN_SAMPLE_RATE = 60000L;
    private static final int TYPE_CPU_WARN = 1;
    private static final int TYPE_MEMORY_WARN = 2;
    private final Context mContext;
    private ICpuWarnListener mCpuCallback;
    private IMemoryWarnListener mMemoryCallback;
    private CPUMemoryConfig mConfig;
    private HashMap<String, SingleProcessWarn> mCache = new HashMap();

    public CPUMemoryCanaryCore(Context context) {
        this.mContext = context;
    }

    public void stop() {
        Logger.d("stop cpu memory core", new Exception());
        if (this.mCache.size() > 0) {
            for (SingleProcessWarn processWarn : this.mCache.values()) {
                processWarn.stop();
            }
        }
    }

    private long getWarnSampleRate() {
        try {
            if (this.mConfig != null) {
                return this.mConfig.getWarnSampleRate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 60000L;
    }

    private int[] getCPUWarnThreshold() {
        try {
            if (this.mConfig != null) {
                int[] ints = this.mConfig.getCPUWarnThreshold();
                if (ints != null) {
                    Arrays.sort(ints);
                }
                return ints;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private int[] getMemoryWarnThreshold() {
        try {
            if (this.mConfig != null) {
                int[] ints = this.mConfig.getMemoryWarnThreshold();
                if (ints != null) {
                    Arrays.sort(ints);
                }
                return ints;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private int getWarnSampleCount() {
        try {
            if (this.mConfig != null) {
                return this.mConfig.getWarnSampleCount();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    private String getProcessName() {
        try {
            return this.mConfig.getProcessName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List getProcessNames() {
        try {
            return this.mConfig.getProcessNames();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List getMemoryWarnConfigs() {
        try {
            return this.mConfig.getMemoryWarnConfigs();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List getCpuWarnConfigs() {
        try {
            return this.mConfig.getCpuWarnConfigs();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setCpuCallback(ICpuWarnListener callback) {
        this.mCpuCallback = callback;
    }

    public void setMemoryCallback(IMemoryWarnListener callback) {
        this.mMemoryCallback = callback;
    }

    public void setConfig(CPUMemoryConfig config) {
        Log.i((String)"OrionBase", (String)"setConfig");
        this.mConfig = config;
    }

    public void resetCPUMemoryWarnCount() {
        Log.i((String)"OrionBase", (String)"resetCPUMemoryWarnCount");
        if (this.mCache.size() > 0) {
            for (SingleProcessWarn processWarn : this.mCache.values()) {
                processWarn.resetCPUMemoryWarnCount();
            }
        }
    }

    public void cleanCpuMemoryConfig() {
        if (this.mCache.size() > 0) {
            for (SingleProcessWarn processWarn : this.mCache.values()) {
                processWarn.stop();
            }
            this.mCache.clear();
        }
    }

    public void startCpuWarn() {
        if (this.mCpuCallback != null) {
            this.detectAppInfo(1);
        }
    }

    public void startMemoryWarn() {
        if (this.mMemoryCallback != null) {
            this.detectAppInfo(2);
        }
    }

    private void detectAppInfo(int flag) {
        block14: {
            block13: {
                String processName = this.getProcessName();
                if (!TextUtils.isEmpty((CharSequence)processName)) {
                    SingleProcessWarn processWarn = this.mCache.get(processName);
                    if (processWarn == null) {
                        processWarn = this.getSimpleProcessWarn(processName);
                        this.mCache.put(processName, processWarn);
                    }
                    if (flag == 2) {
                        processWarn.setMemoryCallback(this.mMemoryCallback);
                        processWarn.startMemoryWarn();
                    } else if (flag == 1) {
                        processWarn.setCpuCallback(this.mCpuCallback);
                        processWarn.startCpuWarn();
                    }
                    return;
                }
                List processNames = this.getProcessNames();
                if (processNames != null && processNames.size() > 0) {
                    for (String name : processNames) {
                        SingleProcessWarn processWarn = this.mCache.get(name);
                        if (processWarn == null) {
                            processWarn = this.getSimpleProcessWarn(name);
                            this.mCache.put(name, processWarn);
                        }
                        if (flag == 2) {
                            processWarn.setMemoryCallback(this.mMemoryCallback);
                            processWarn.startMemoryWarn();
                            continue;
                        }
                        if (flag != 1) continue;
                        processWarn.setCpuCallback(this.mCpuCallback);
                        processWarn.startCpuWarn();
                    }
                    return;
                }
                if (flag != 2) break block13;
                List memoryConfigs = this.getMemoryWarnConfigs();
                if (memoryConfigs == null) {
                    return;
                }
                for (WarnConfig config : memoryConfigs) {
                    this.setWarnConfig(config, 2);
                }
                break block14;
            }
            if (flag != 1) break block14;
            List cpuWarnConfigs = this.getCpuWarnConfigs();
            if (cpuWarnConfigs == null) {
                return;
            }
            for (WarnConfig config : cpuWarnConfigs) {
                this.setWarnConfig(config, 1);
            }
        }
    }

    private void setWarnConfig(WarnConfig config, int flag) {
        String processName = config.getProcessName();
        SingleProcessWarn processWarn = this.mCache.get(processName);
        if (processWarn == null) {
            processWarn = new SingleProcessWarn(this.mContext);
            processWarn.setProcessName(processName);
            this.mCache.put(processName, processWarn);
        }
        if (flag == 2) {
            processWarn.setMemoryWarnThreshold(config.getWarnThreshold());
            processWarn.setMemoryWarnSampleRate(config.getWarnSampleRate());
            processWarn.setMemoryWarnSampleCount(config.getWarnSampleCount());
            processWarn.setMemoryCallback(this.mMemoryCallback);
            processWarn.startMemoryWarn();
        } else if (flag == 1) {
            processWarn.setCPUWarnThreshold(config.getWarnThreshold());
            processWarn.setCpuWarnSampleRate(config.getWarnSampleRate());
            processWarn.setCpuWarnSampleCount(config.getWarnSampleCount());
            processWarn.setCpuCallback(this.mCpuCallback);
            processWarn.startCpuWarn();
        }
    }

    private SingleProcessWarn getSimpleProcessWarn(String processName) {
        SingleProcessWarn processWarn = new SingleProcessWarn(this.mContext);
        processWarn.setProcessName(processName);
        processWarn.setCpuWarnSampleCount(this.getWarnSampleCount());
        processWarn.setMemoryWarnSampleCount(this.getWarnSampleCount());
        processWarn.setCPUWarnThreshold(this.getCPUWarnThreshold());
        processWarn.setMemoryWarnThreshold(this.getMemoryWarnThreshold());
        processWarn.setCpuWarnSampleRate(this.getWarnSampleRate());
        processWarn.setMemoryWarnSampleRate(this.getWarnSampleRate());
        return processWarn;
    }
}

