/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory.config;

import com.ainirobot.base.plugin.IDynamicConfig;
import com.ainirobot.base.util.Logger;
import java.util.ArrayList;
import java.util.List;

public final class CPUMemoryConfig {
    private static final long DEFAULT_THRESHOLD = 60000L;
    private static final int[] DEFAULT_CPU_WARN_THRESHOLD = new int[]{50, 90};
    private static final int[] DEFAULT_MEMORY_WARN_THRESHOLD = new int[]{61440, 102400};
    private static final int DEFAULT_WARN_COUNT = 1;
    private static final long DEFAULT_WARN_SAMPLE_RATE = 60000L;
    private static final List<String> EMPTY_LIST = new ArrayList<String>();
    private final IDynamicConfig mDynamicConfig;

    private CPUMemoryConfig(IDynamicConfig dynamicConfig) {
        this.mDynamicConfig = dynamicConfig;
        Logger.i("CPUMemoryConfig()", new Object[0]);
    }

    public long getThreshold() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_cpu_memory_threshold.name(), 60000L);
    }

    public long getWarnSampleRate() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_warn_sample_rate.name(), 60000L);
    }

    public int getWarnSampleCount() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_warn_sample_count.name(), 1);
    }

    public int[] getCPUWarnThreshold() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_cpu_warn_threshold.name(), DEFAULT_CPU_WARN_THRESHOLD);
    }

    public int[] getMemoryWarnThreshold() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_memory_warn_threshold.name(), DEFAULT_MEMORY_WARN_THRESHOLD);
    }

    public String getProcessName() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_cpu_memory_processname.name(), "");
    }

    public List getProcessNames() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_cpu_memory_processnames.name(), EMPTY_LIST);
    }

    public List getMemoryWarnConfigs() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_warn_memory_configs.name(), EMPTY_LIST);
    }

    public List getCpuWarnConfigs() {
        return this.mDynamicConfig.get(ExptEnum.orionbase_warn_cpu_configs.name(), EMPTY_LIST);
    }

    public static final class Builder {
        private IDynamicConfig dynamicConfig;

        public Builder dynamicConfig(IDynamicConfig dynamicConfig) {
            this.dynamicConfig = dynamicConfig;
            return this;
        }

        public CPUMemoryConfig build() {
            return new CPUMemoryConfig(this.dynamicConfig);
        }
    }

    public static enum ExptEnum {
        orionbase_cpu_warn_threshold,
        orionbase_memory_warn_threshold,
        orionbase_warn_sample_rate,
        orionbase_warn_sample_count,
        orionbase_cpu_memory_threshold,
        orionbase_cpu_memory_processname,
        orionbase_cpu_memory_processnames,
        orionbase_warn_memory_configs,
        orionbase_warn_cpu_configs;

    }
}

