/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory;

import android.content.Context;
import com.ainirobot.base.cpumemory.CPUMemoryCanaryPlugin;
import com.ainirobot.base.cpumemory.config.CPUMemoryConfig;
import com.ainirobot.base.cpumemory.core.CPUMemoryCanaryCore;
import com.ainirobot.base.listener.ICpuWarnListener;
import com.ainirobot.base.listener.IMemoryWarnListener;

public class PerformanceCanaryClient {
    private CPUMemoryCanaryCore mCore;

    public static PerformanceCanaryClient Instance() {
        return LazyHolder.INSTANCE;
    }

    private void init(Context context) {
    }

    private void setConfig() {
    }

    public void resetCPUMemoryWarnCount() {
        this.mCore.resetCPUMemoryWarnCount();
    }

    public void cleanCpuMemoryConfig() {
        this.mCore.cleanCpuMemoryConfig();
    }

    public void start(CPUMemoryCanaryPlugin plugin) {
        if (plugin != null) {
            Context context = plugin.getApplicationContext();
            if (context == null) {
                return;
            }
            CPUMemoryConfig config = plugin.getConfig();
            if (config == null) {
                return;
            }
            this.mCore = new CPUMemoryCanaryCore(context);
            this.mCore.setConfig(config);
        }
    }

    public void stop(CPUMemoryCanaryPlugin plugin) {
        if (this.mCore != null) {
            this.mCore.stop();
        }
    }

    public void setCpuWarningListener(ICpuWarnListener cpuWarningListener) {
        if (cpuWarningListener != null) {
            this.mCore.setCpuCallback(cpuWarningListener);
            this.mCore.startCpuWarn();
        }
    }

    public void setMemoryWarningListener(IMemoryWarnListener memoryWarningListener) {
        if (memoryWarningListener != null) {
            this.mCore.setMemoryCallback(memoryWarningListener);
            this.mCore.startMemoryWarn();
        }
    }

    private static class LazyHolder {
        private static final PerformanceCanaryClient INSTANCE = new PerformanceCanaryClient();

        private LazyHolder() {
        }
    }
}

