/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory;

import android.content.Context;
import com.ainirobot.base.cpumemory.PerformanceCanaryClient;
import com.ainirobot.base.cpumemory.config.CPUMemoryConfig;
import com.ainirobot.base.cpumemory.core.CPUMemoryReportCanaryCore;
import com.ainirobot.base.listener.ICpuWarnListener;
import com.ainirobot.base.listener.IMemoryWarnListener;
import com.ainirobot.base.plugin.DefaultConfig;
import com.ainirobot.base.plugin.IDynamicConfig;
import com.ainirobot.base.plugin.Plugin;
import com.ainirobot.base.plugin.PluginListener;
import com.ainirobot.base.report.ReportData;
import com.ainirobot.base.util.Logger;

public class CPUMemoryCanaryPlugin
extends Plugin<ReportData> {
    private final CPUMemoryConfig mCPUConfig;
    private PerformanceCanaryClient mClient;
    private CPUMemoryReportCanaryCore mReportCore;

    public CPUMemoryCanaryPlugin() {
        this.mCPUConfig = new CPUMemoryConfig.Builder().dynamicConfig(new DefaultConfig()).build();
    }

    public CPUMemoryCanaryPlugin(IDynamicConfig config) {
        this.mCPUConfig = config == null ? new CPUMemoryConfig.Builder().dynamicConfig(new DefaultConfig()).build() : new CPUMemoryConfig.Builder().dynamicConfig(config).build();
    }

    @Override
    public void init(Context context, PluginListener listener) {
        super.init(context, listener);
        this.mClient = PerformanceCanaryClient.Instance();
    }

    @Override
    public synchronized void start() {
        if (!this.isPluginStarted()) {
            super.start();
            this.mClient.start(this);
            new Thread(){

                @Override
                public void run() {
                    CPUMemoryReportCanaryCore.getInstance().init(CPUMemoryCanaryPlugin.this.getApplicationContext());
                    if (CPUMemoryCanaryPlugin.this.mPluginHandler != null) {
                        CPUMemoryReportCanaryCore.getInstance().setPluginHandler(CPUMemoryCanaryPlugin.this.mPluginHandler);
                        CPUMemoryReportCanaryCore.getInstance().start();
                    }
                }
            }.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.isPluginStarted()) {
            super.stop();
            this.mClient.stop(this);
            if (this.mReportCore != null) {
                this.mReportCore.stop();
            }
        }
    }

    public CPUMemoryConfig getConfig() {
        return this.mCPUConfig;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public String getTag() {
        return "cpuinfo";
    }

    @Override
    public synchronized void onForeground(boolean isForground) {
        Logger.i("onForeground:" + isForground, new Object[0]);
        super.onForeground(isForground);
    }

    public void setCpuWarningListener(ICpuWarnListener cpuWarningListener) {
        if (this.mClient != null) {
            this.mClient.setCpuWarningListener(cpuWarningListener);
        }
    }

    public void setMemoryWarningListener(IMemoryWarnListener memoryWarningListener) {
        if (this.mClient != null) {
            this.mClient.setMemoryWarningListener(memoryWarningListener);
        }
    }

    public void resetCPUMemoryWarnCount() {
        if (this.mClient != null) {
            this.mClient.resetCPUMemoryWarnCount();
        }
    }

    public void cleanCpuMemoryConfig() {
        if (this.mClient != null) {
            this.mClient.cleanCpuMemoryConfig();
        }
    }
}

