/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cpumemory;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.ainirobot.base.cpumemory.aidl.ICpuFreMonitorCallback;
import com.ainirobot.base.cpumemory.aidl.IInterface;
import com.ainirobot.base.cpumemory.aidl.ITempMonitorCallback;
import com.ainirobot.base.listener.ICpuFreMonitorListener;
import com.ainirobot.base.listener.ITempMonitorListener;

public class CPUFreTempMonitorClient
implements ServiceConnection {
    private Context mContext;
    private IInterface mInterface;
    private ICpuFreMonitorListener mICpuFreMonitorListener;
    private ITempMonitorListener mITempMonitorListener;

    public static CPUFreTempMonitorClient getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void start(Context context) {
        if (context == null) {
            return;
        }
        this.mContext = context.getApplicationContext();
        Intent intent = new Intent();
        intent.setAction("android.service.aidl.CPUFreTempMonitorService");
        intent.setPackage("com.ainirobot.coreservice");
        this.mContext.bindService(intent, (ServiceConnection)this, 1);
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.mInterface = IInterface.Stub.asInterface(service);
        if (this.mICpuFreMonitorListener != null) {
            this.setCpuFreMonitorListener(this.mICpuFreMonitorListener);
        }
        if (this.mITempMonitorListener != null) {
            this.setTempMonitorListener(this.mITempMonitorListener);
        }
    }

    public void onServiceDisconnected(ComponentName name) {
    }

    public void setCpuFreMonitorListener(final ICpuFreMonitorListener cpuFreMonitorListener) {
        if (this.mInterface != null) {
            try {
                this.mInterface.setCpuMonitorCallback(new ICpuFreMonitorCallback.Stub(){

                    @Override
                    public void cpuFreMonitor(String cpuFre) throws RemoteException {
                        if (cpuFreMonitorListener != null) {
                            cpuFreMonitorListener.cpuFreMonitor(cpuFre);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cpuFreMonitorListener != null) {
            this.mICpuFreMonitorListener = cpuFreMonitorListener;
        }
    }

    public void setTempMonitorListener(final ITempMonitorListener tempMonitorListnenr) {
        if (this.mInterface != null) {
            try {
                this.mInterface.setTempMonitorCallback(new ITempMonitorCallback.Stub(){

                    @Override
                    public void tempMonitor(String temp) throws RemoteException {
                        if (tempMonitorListnenr != null) {
                            tempMonitorListnenr.tempMonitor(temp);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (tempMonitorListnenr != null) {
            this.mITempMonitorListener = tempMonitorListnenr;
        }
    }

    private static class SingletonHolder {
        private static final CPUFreTempMonitorClient INSTANCE = new CPUFreTempMonitorClient();

        private SingletonHolder() {
        }
    }
}

