/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cos;

import com.ainirobot.base.network.HttpMethod;
import com.ainirobot.base.network.HttpRequest;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.report.AbstractSpiCall;
import org.json.JSONObject;

public final class TokenSpiCall
extends AbstractSpiCall {
    public TokenSpiCall(String url, HttpRequestFactory requestFactory) {
        super(url, requestFactory, HttpMethod.POST);
    }

    public JSONObject invoke(String requestData) throws Exception {
        HttpRequest httpRequest = this.applyHeadersTo(this.getHttpRequest());
        httpRequest.readTimeout(30000).connectTimeout(30000);
        httpRequest = this.applyMultipartDataTo(httpRequest, requestData);
        JSONObject toReturn = this.handleResponse(httpRequest);
        return toReturn;
    }

    private HttpRequest applyHeadersTo(HttpRequest request) {
        this.applyNonNullHeader(request, "Content-Type", "application/x-www-form-urlencoded");
        return request;
    }

    private void applyNonNullHeader(HttpRequest request, String key, String value) {
        if (value != null) {
            request.header(key, value);
        }
    }

    private HttpRequest applyMultipartDataTo(HttpRequest request, String queryParams) {
        try {
            request.send(queryParams.getBytes());
            return request;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject handleResponse(HttpRequest httpRequest) throws Exception {
        int statusCode = httpRequest.code();
        if (!this.requestWasSuccessful(statusCode)) {
            throw new RuntimeException("HttpRequest error = " + statusCode);
        }
        JSONObject toReturn = this.getJsonObjectFrom(httpRequest.body());
        return toReturn;
    }

    private boolean requestWasSuccessful(int httpStatusCode) {
        return httpStatusCode == 200;
    }

    private JSONObject getJsonObjectFrom(String httpRequestBody) throws Exception {
        return new JSONObject(httpRequestBody);
    }
}

