/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.cos;

import android.os.Build;
import android.text.TextUtils;
import com.ainirobot.base.config.Constants;
import com.ainirobot.base.util.BackgroundWorker;
import com.ainirobot.base.util.ExecutorUtils;
import com.ainirobot.base.util.FileUtils;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.OrionBaseUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CosManager {
    public static final String COS_BUCKET = "ovs-bigdata-1256573505";
    public static final String COS_REGION = "ap-beijing";
    private static final String COS_URL_TEST = "http://ai-open-test.ainirobot.com";
    private static final String COS_URL_FORMAL = "https://ai-open.ainirobot.com";
    private static final String TAG = "CosManager";
    private static final String KEY_PATH = "/bigdata/api/v1/cos/anr/file/secret";
    private static final String TOKEN_PATH = "/oauth/2.0/token";
    private static final String APP_SECRET = "824416C04CC211EAB2499D538CA28633";
    private static final String APP_ID = "orion.appid.1581420888108";
    private static final String BUCKET_DIR = "/orionbase/anr/";
    private static final String TEMP_SUFFIX = "_cache";
    private String mToken;
    private BackgroundWorker mBackgroundWorker = new BackgroundWorker(ExecutorUtils.buildSingleThreadExecutorService());

    private static final String getCosUrl() {
        return Constants.BUILD_TYPE_UNIT_TEST ? COS_URL_TEST : COS_URL_FORMAL;
    }

    private CosManager() {
    }

    public static final CosManager getInstance() {
        return SingletonHolder.Instance;
    }

    private String getTokenParams() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("grant_type=" + URLEncoder.encode("client_credentials", "utf-8"));
            sb.append("&");
            sb.append("client_id=" + URLEncoder.encode(this.getAppID(), "utf-8"));
            sb.append("&");
            sb.append("client_secret=" + URLEncoder.encode(this.getAppSecret(), "utf-8"));
            sb.append("&");
            sb.append("request_id=" + URLEncoder.encode(this.getRequestID(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String getSecretParams(String filePath) {
        StringBuffer sb = new StringBuffer();
        try {
            String appId = URLEncoder.encode(this.getAppID(), "utf-8");
            String timeStamp = URLEncoder.encode(this.getTimeStamp(), "utf-8");
            String requestId = URLEncoder.encode(this.getRequestID(), "utf-8");
            String token = URLEncoder.encode(this.getToken(), "utf-8");
            sb.append("?app_id=" + appId);
            sb.append("&");
            sb.append("timestamp=" + timeStamp);
            sb.append("&");
            sb.append("request_id=" + requestId);
            sb.append("&");
            sb.append("token=" + token);
            sb.append("&");
            sb.append("sign=" + URLEncoder.encode(this.getSign(appId, timeStamp, requestId, token, filePath), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String getAppID() {
        return APP_ID;
    }

    private String getAppSecret() {
        return APP_SECRET;
    }

    private String getTimeStamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    private String getRequestID() {
        return String.valueOf(System.nanoTime());
    }

    private String getToken() {
        return TextUtils.isEmpty((CharSequence)this.mToken) ? "" : this.mToken;
    }

    private void setToken(String token) {
        this.mToken = token;
    }

    private String getSign(String appId, String timeStamp, String requestID, String token, String filePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_id", appId);
        map.put("timestamp", timeStamp);
        map.put("request_id", requestID);
        map.put("token", token);
        return this.getSign(map, filePath);
    }

    private String getSign(Map<String, String> paramsMap, String fileMd5) {
        String sign = "";
        try {
            if ((paramsMap == null || paramsMap.size() == 0) && TextUtils.isEmpty((CharSequence)fileMd5)) {
                return null;
            }
            ArrayList<String> keyList = new ArrayList<String>(paramsMap.keySet());
            Collections.sort(keyList);
            StringBuilder builder = new StringBuilder();
            for (String key : keyList) {
                String val = paramsMap.get(key);
                if (val == null || "".equals(val.trim())) continue;
                builder.append(key).append("=").append(val).append("&");
            }
            builder.deleteCharAt(builder.lastIndexOf("&"));
            builder.append("{\"filePath\":\"").append(fileMd5).append("\"}");
            builder.append("&").append("app_secret").append("=").append(APP_SECRET);
            System.out.println("\u52a0\u5bc6\u524d\u5b57\u7b26\u4e32\uff1a" + builder.toString());
            String base64Sign = "";
            if (Build.VERSION.SDK_INT >= 26) {
                base64Sign = new String(Base64.getEncoder().encode(builder.toString().getBytes()), StandardCharsets.UTF_8);
            } else {
                Logger.i("sdk version need newer than 26.", new Object[0]);
                base64Sign = new String(OrionBaseUtil.encode(builder.toString().getBytes()));
            }
            sign = OrionBaseUtil.getMD5String(base64Sign);
            if (!TextUtils.isEmpty((CharSequence)sign)) {
                sign = sign.toLowerCase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sign;
    }

    public File tempFile(File file) {
        try {
            String filePath = file.getAbsolutePath();
            File tempFile = new File(filePath + TEMP_SUFFIX);
            FileUtils.renameTempFile(file, tempFile);
            return tempFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void resetFile(File file) {
        try {
            String tempFilePath = file.getAbsolutePath();
            if (tempFilePath.endsWith(TEMP_SUFFIX)) {
                int index = tempFilePath.lastIndexOf(TEMP_SUFFIX);
                String filePath = tempFilePath.substring(0, index);
                File nfile = new File(filePath);
                FileUtils.renameTempFile(file, nfile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getBucketPath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        int index = path.lastIndexOf("/");
        path = path.substring(index);
        StringBuilder builder = new StringBuilder();
        builder.append(BUCKET_DIR);
        if (Constants.BUILD_TYPE_UNIT_TEST) {
            builder.append("test/");
        } else {
            builder.append("formal/");
        }
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        builder.append(date);
        builder.append(path);
        return builder.toString();
    }

    private static final class SingletonHolder {
        private static final CosManager Instance = new CosManager();

        private SingletonHolder() {
        }
    }
}

