/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.contentprovider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.ainirobot.base.ApplicationWrapper;
import com.ainirobot.base.contentprovider.ErrorInfo;
import java.util.ArrayList;
import java.util.List;

public class ErrorInfoResolver {
    private ContentResolver mResolver;
    private Uri mUri = Uri.parse((String)"content://com.ainirobot.base.contentprovider.ErrorInfo/error");

    public static final ErrorInfoResolver getInstance() {
        return SingletonHolder.mInstance;
    }

    private ErrorInfoResolver() {
        Context content = ApplicationWrapper.getApplicationContext();
        this.mResolver = content.getContentResolver();
    }

    public void insert(ErrorInfo info) {
        if (!TextUtils.isEmpty((CharSequence)info.fileName) && !TextUtils.isEmpty((CharSequence)info.shortMsg)) {
            ContentValues values = new ContentValues();
            values.put("FileName", info.fileName);
            values.put("ShortMsg", info.shortMsg);
            values.put("TYPE", Integer.valueOf(info.type));
            values.put("TimeStamp", Long.valueOf(info.timeStamp));
            this.mResolver.insert(this.mUri, values);
        }
    }

    public List<ErrorInfo> query() {
        ArrayList<ErrorInfo> list = new ArrayList<ErrorInfo>();
        Cursor cursor = this.mResolver.query(this.mUri, new String[]{"FileName", "ShortMsg", "Type", "TimeStamp"}, null, null, null);
        while (cursor.moveToNext()) {
            String fileName = cursor.getString(0);
            String shortMsg = cursor.getString(1);
            int type = cursor.getInt(2);
            long timeStamp = cursor.getLong(3);
            ErrorInfo info = new ErrorInfo();
            info.fileName = fileName;
            info.shortMsg = shortMsg;
            info.type = type;
            info.timeStamp = timeStamp;
            list.add(info);
        }
        return list;
    }

    public int delete(String shortMsg) {
        try {
            return this.mResolver.delete(this.mUri, "ShortMsg=?", new String[]{shortMsg});
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static final class SingletonHolder {
        private static final ErrorInfoResolver mInstance = new ErrorInfoResolver();

        private SingletonHolder() {
        }
    }
}

