/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

public final class StringUtil {
    private static final String QUOTE = "\"";
    private static final String EMPTY_QUOTE_STR = "\"\"";
    private static final String HANZI = "[^\\x00-\\xff]";
    private static final long TM = 60L;
    private static final long TH = 3600L;
    private static final long TD = 86400L;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final long KR = 1000L;
    private static final long MR = 1024000L;
    private static final long GR = 1048576000L;

    public static boolean checkLength(String phoneNumber) {
        return !StringUtil.isNullOrEmpty(phoneNumber) && phoneNumber.length() > 10;
    }

    public static boolean isNull(String str) {
        return str == null;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() < 1;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }

    public static boolean equalsWithEmpty(String str1, String str2) {
        if (StringUtil.isNullOrEmpty(str1) && StringUtil.isNullOrEmpty(str2)) {
            return true;
        }
        return StringUtil.equals(str1, str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 != null && str1.equalsIgnoreCase(str2);
    }

    public static boolean contains(String str1, String str2) {
        return str1 != null && str1.contains(str2);
    }

    public static String getString(String str) {
        return str == null ? "" : str;
    }

    public static String unquote(String s, String quote) {
        if (s != null && quote != null && s.startsWith(quote) && s.endsWith(quote)) {
            return s.substring(1, s.length() - quote.length());
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static String filterHtmlTag(String inputString) {
        String htmlStr = inputString;
        String textStr = "";
        try {
            String regExScript = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?/[\\s]*?script[\\s]*?>";
            String regExStyle = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?/[\\s]*?style[\\s]*?>";
            String regExHtml = "<[^>\"]+>";
            Pattern pScript = Pattern.compile(regExScript, 2);
            Matcher mScript = pScript.matcher(htmlStr);
            htmlStr = mScript.replaceAll("");
            Pattern pStyle = Pattern.compile(regExStyle, 2);
            Matcher mStyle = pStyle.matcher(htmlStr);
            htmlStr = mStyle.replaceAll("");
            Pattern pHtml = Pattern.compile(regExHtml, 2);
            Matcher mHtml = pHtml.matcher(htmlStr);
            textStr = htmlStr = mHtml.replaceAll("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return textStr;
    }

    public static String arrayToString(String[] values) {
        StringBuilder result = new StringBuilder();
        String retStr = "";
        if (values != null && values.length > 0) {
            for (String value : values) {
                result.append(value).append(",");
            }
            retStr = result.substring(0, result.length() - 1).toString();
        }
        return retStr;
    }

    public static boolean isEmail(String email) {
        boolean flag = true;
        if (!StringUtil.isNullOrEmpty(email)) {
            flag = email.matches("[a-zA-Z0-9\\+\\.\\_\\%\\-\\+]{1,256}\\@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{0,25})+");
            return flag;
        }
        return flag;
    }

    public static boolean isNumeric(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String encodeString(String strData) {
        if (strData == null) {
            return "";
        }
        strData = strData.replaceAll("&", "&amp;");
        strData = strData.replaceAll("<", "&lt;");
        strData = strData.replaceAll(">", "&gt;");
        strData = strData.replaceAll("'", "&apos;");
        strData = strData.replaceAll(QUOTE, "&quot;");
        return strData;
    }

    public static String encodeStrngOnly(String strData) {
        if (strData == null) {
            return "";
        }
        strData = strData.replaceAll("&", "&amp;");
        return strData;
    }

    public static String getQuoteString(String str) {
        return StringUtil.isNull(str) ? EMPTY_QUOTE_STR : QUOTE + str + QUOTE;
    }

    public static String decodeString(String strData) {
        if (strData == null) {
            return "";
        }
        strData = strData.replaceAll("&lt;", "<");
        strData = strData.replaceAll("&gt;", ">");
        strData = strData.replaceAll("&apos;", "'");
        strData = strData.replaceAll("&quot;", QUOTE);
        strData = strData.replaceAll("&amp;", "&");
        return strData;
    }

    public static String generateXml(Map<String, Object> map) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<root>");
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                xml.append("<");
                xml.append(key);
                xml.append(">");
                xml.append(entry.getValue());
                xml.append("</");
                xml.append(key);
                xml.append(">");
            }
        }
        xml.append("</root>");
        return xml.toString();
    }

    public static String generateXml(String ... values) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<root>");
        if (values != null) {
            int size = values.length >> 1;
            for (int i = 0; i < size; ++i) {
                xml.append("<");
                xml.append(values[i << 1]);
                xml.append(">");
                xml.append(values[(i << 1) + 1]);
                xml.append("</");
                xml.append(values[i << 1]);
                xml.append(">");
            }
        }
        xml.append("</root>");
        return xml.toString();
    }

    public static String parseListToString(List<String> list, String splitStr) {
        if (list != null && list.size() > 0) {
            StringBuilder result = new StringBuilder();
            if (StringUtil.isNullOrEmpty(splitStr)) {
                splitStr = "|";
            }
            for (int i = 0; i < list.size(); ++i) {
                result.append(list.get(i));
                result.append(splitStr);
            }
            result.deleteCharAt(result.length() - 1);
            return result.toString();
        }
        return null;
    }

    public static List<String> parseStringToList(String str, String splitStr) {
        ArrayList<String> list = null;
        if (!StringUtil.isNullOrEmpty(str)) {
            String[] temp;
            if (StringUtil.isNullOrEmpty(splitStr)) {
                splitStr = "\\|";
            }
            if ((temp = str.split(splitStr)) != null && temp.length > 0) {
                list = new ArrayList<String>();
                for (int i = 0; i < temp.length; ++i) {
                    list.add(temp[i]);
                }
            }
        }
        return list;
    }

    public static String fixUrl(String url) {
        if (url == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(url);
        int i = stringBuffer.indexOf("//", stringBuffer.indexOf("//") + 2);
        while (i != -1) {
            stringBuffer.deleteCharAt(i);
            i = stringBuffer.indexOf("//", i + 1);
        }
        return stringBuffer.toString();
    }

    public static int count2BytesChar(String string) {
        int count = 0;
        if (string != null) {
            for (char c : string.toCharArray()) {
                ++count;
                if (!StringUtil.isChinese(c)) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean hasChinese(String str) {
        boolean hasChinese = false;
        if (str != null) {
            for (char c : str.toCharArray()) {
                if (!StringUtil.isChinese(c)) continue;
                hasChinese = true;
                break;
            }
        }
        return hasChinese;
    }

    public static String subString(String src, int charLength) {
        if (src != null) {
            int i = 0;
            for (char c : src.toCharArray()) {
                ++i;
                --charLength;
                if (StringUtil.isChinese(c)) {
                    --charLength;
                }
                if (charLength > 0) continue;
                if (charLength >= 0) break;
                --i;
                break;
            }
            return src.substring(0, i);
        }
        return src;
    }

    public static String trim(String originStr, int maxCharLength) {
        int index = 0;
        int originLen = originStr.length();
        for (int i = 0; index < originLen && i < maxCharLength; ++i) {
            if (!StringUtil.isChinese(originStr.charAt(index++))) continue;
            ++i;
        }
        if (index < originLen) {
            return originStr.substring(0, index) + "...";
        }
        return originStr;
    }

    public static boolean isChinese(char c) {
        return Pattern.matches(HANZI, String.valueOf(c));
    }

    public static String getAppVersionName(Context context) {
        String versionName = "";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            versionName = pi.versionName;
            if (versionName == null || versionName.length() <= 0) {
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versionName;
    }

    public static int getAppVersionCode(Context context) {
        int versionCode = 0;
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            versionCode = pi.versionCode;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versionCode;
    }

    public static String getVersionShow(String verName, int versionCode) {
        String verCodeStr = versionCode + "";
        int codeLength = verCodeStr.length();
        if (codeLength < 3) {
            return verName;
        }
        return verName + "." + verCodeStr.substring(codeLength - 3, codeLength);
    }

    public static String createRandomString(int min, int max) {
        StringBuffer strB = new StringBuffer();
        Random random = new Random();
        int lenght = min;
        if (max > min) {
            lenght += random.nextInt(max - min + 1);
        }
        for (int i = 0; i < lenght; ++i) {
            strB.append((char)(97 + random.nextInt(26)));
        }
        return strB.toString();
    }

    public static int getStringLeng(String content) {
        double num = 0.0;
        if (StringUtil.isNullOrEmpty(content)) {
            return 0;
        }
        for (int i = 0; i < content.length(); ++i) {
            if (StringUtil.isChinese(content.charAt(i))) {
                num += 1.0;
                continue;
            }
            num += 0.5;
        }
        return (int)Math.ceil(num) * 2;
    }

    public static int getCharLeng(String content) {
        int num = 0;
        if (StringUtil.isNullOrEmpty(content)) {
            return num;
        }
        for (int i = 0; i < content.length(); ++i) {
            if (StringUtil.isChinese(content.charAt(i))) {
                num += 2;
                continue;
            }
            ++num;
        }
        return num;
    }

    public static String getString(String content, int length) {
        double num = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < content.length(); ++i) {
            if (StringUtil.isChinese(content.charAt(i))) {
                if ((double)length - num == 1.0) break;
                num += 2.0;
            } else {
                num += 1.0;
            }
            stringBuffer.append(content.charAt(i));
            if (num >= (double)length) break;
        }
        return stringBuffer.toString();
    }

    public static String append(Object ... args) {
        if (args == null || args.length < 1) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Object arg : args) {
            buf.append(arg);
        }
        return buf.toString();
    }

    public static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    public static boolean endsWith(String str, String suffix) {
        return str != null && str.endsWith(suffix);
    }

    public static String trim(String str, String encoding, int maxLength) {
        if (str == null || encoding == null || maxLength < 1) {
            return str;
        }
        if ("UTF-8".equalsIgnoreCase(encoding) && maxLength > str.length() * 3 || ("GBK".equalsIgnoreCase(encoding) || "GB2312".equalsIgnoreCase(encoding)) && maxLength > str.length() * 2) {
            return str;
        }
        if (maxLength < str.length()) {
            str = str.substring(0, maxLength);
        }
        try {
            String newStr;
            byte[] bytes = str.getBytes(encoding);
            int end = bytes.length;
            if (maxLength < end) {
                end = maxLength;
            }
            if ((newStr = new String(bytes, 0, end, encoding)).charAt(newStr.length() - 1) != str.charAt(newStr.length() - 1)) {
                newStr = newStr.substring(0, newStr.length() - 1);
            }
            return newStr;
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static int getStrLeng(String content) {
        double num = 0.0;
        if (StringUtil.isNullOrEmpty(content)) {
            return 0;
        }
        for (int i = 0; i < content.length(); ++i) {
            if (StringUtil.isChinese(content.charAt(i))) {
                num += 2.0;
                continue;
            }
            num += 1.0;
        }
        return (int)Math.ceil(num);
    }

    public static String getMD5(String str) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            return "";
        }
        if (str == null) {
            return "";
        }
        char[] charArray = str.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String getMD5HexString(String str) {
        if (null == str) {
            return "";
        }
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = str.getBytes();
            msgDigest.update(bytes);
            bytes = msgDigest.digest();
            return StringUtil.toHexString(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null || bytes.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        int v = 0;
        String hexV = null;
        for (byte b : bytes) {
            v = b & 0xFF;
            hexV = Integer.toHexString(v);
            if (hexV.length() < 2) {
                sb.append("0");
            }
            sb.append(hexV);
        }
        return sb.toString();
    }

    public static byte[] toBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        int strLen = hexString.length();
        int bytesLen = strLen / 2;
        ByteBuffer bb = ByteBuffer.allocate(bytesLen);
        int intV = 0;
        for (int i = 0; i < strLen; i += 2) {
            intV = Integer.valueOf(hexString.substring(i, i + 2), 16);
            bb.put((byte)intV);
        }
        return bb.array();
    }

    public static String formatTime(String format, Long time) {
        String timeFormat = String.format(format, time / 3600L, (time - time / 3600L * 3600L) / 60L, time % 60L);
        return timeFormat;
    }

    public static int storeIp(String strIp) {
        String[] str = strIp.split("\\.");
        Integer i = 0;
        for (String s : str) {
            int it = Integer.valueOf(s);
            i = i << 8;
            i = i | it;
        }
        return i;
    }

    public static boolean isHtml(String text) {
        String rex = "<[^>]+>";
        Pattern pattern = Pattern.compile(rex);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            text = text.replace("\\n", "<br/>");
            return true;
        }
        return false;
    }

    public static String convertToTimeString(long millis) {
        long time = millis / 1000L;
        if (time < 60L) {
            if (millis < 10000L) {
                if (millis < 100L) {
                    millis = 100L;
                }
                double tempTime = (double)millis * 1.0 / 1000.0;
                BigDecimal bg = new BigDecimal(tempTime);
                double timeStr = bg.setScale(1, 4).doubleValue();
                return timeStr + "\u79d2";
            }
            return time + "\u79d2";
        }
        if (time < 3600L) {
            long s = time % 60L;
            return time / 60L + "\u5206\u949f" + (s > 0L ? s + "\u79d2" : "");
        }
        if (time < 86400L) {
            long m = time % 3600L / 60L;
            return time / 3600L + "\u5c0f\u65f6" + (m > 0L ? m + "\u5206\u949f" : "");
        }
        long h = time % 86400L / 3600L;
        return time / 86400L + "\u5929" + (h > 0L ? h + "\u5c0f\u65f6" : "");
    }

    public static String convertToRealSizeString(long value) {
        if (value < 1L) {
            return "0B";
        }
        long[] dividers = new long[]{0x10000000000L, 0x40000000L, 0x100000L, 1024L, 1L};
        String[] units = new String[]{"TB", "GB", "MB", "KB", "B"};
        String result = null;
        for (int i = 0; i < dividers.length; ++i) {
            long divider = dividers[i];
            if (value < divider) continue;
            result = StringUtil.format(value, divider, 1, units[i]);
            break;
        }
        return result;
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String format(long value, long divider, int precise, String unit) {
        double result = divider > 1L ? (double)value / (double)divider : (double)value;
        return String.format("%." + precise + "f%s", result, unit);
    }

    public static String convertToSizeString(long bytes) {
        return StringUtil.convertToSizeString((double)bytes);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String convertToSizeString(double bytes) {
        String suffix = null;
        double value = 0.0;
        if (bytes < 1000.0) {
            suffix = "B";
            value = bytes;
        } else if (bytes < 1024000.0) {
            suffix = "KB";
            value = bytes / 1024.0;
        } else if (bytes < 1.048576E9) {
            suffix = "MB";
            value = bytes / 1048576.0;
        } else {
            suffix = "GB";
            value = bytes / 1.073741824E9;
        }
        if (value == (double)((long)value)) {
            return String.format("%d", (long)value) + suffix;
        }
        String str = String.format("%.3f", value);
        int index = str.indexOf(".");
        if (index >= 3) {
            return str.substring(0, index) + suffix;
        }
        if (str.length() > 4) {
            return str.substring(0, 4) + suffix;
        }
        return str + suffix;
    }

    public static double getSize(double size) {
        double calculatenum = 0.0;
        if (!(size > 0.0)) {
            return 0.0;
        }
        double sizes = size;
        calculatenum = sizes / 1024.0 / 1024.0;
        calculatenum = (double)Math.round(calculatenum * 10.0) / 10.0;
        if (calculatenum <= 0.0) {
            calculatenum = 0.1;
        }
        return calculatenum;
    }

    public static String getSize2(long size) {
        double calculatenum = 0.0;
        if (size > 0L) {
            BigDecimal bigDec = BigDecimal.valueOf(size);
            calculatenum = bigDec.divide(BigDecimal.valueOf(0x100000L)).doubleValue();
            if (calculatenum > 1024.0) {
                calculatenum = BigDecimal.valueOf(calculatenum).divide(BigDecimal.valueOf(1024L)).doubleValue();
                calculatenum = (double)Math.round(calculatenum * 10.0) / 10.0;
                return calculatenum + "G";
            }
            calculatenum = (double)Math.round(calculatenum * 10.0) / 10.0;
        }
        return calculatenum + "M";
    }

    public static byte[] compress(byte[] bytes) throws IOException {
        if (null == bytes || bytes.length <= 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(bytes);
        gzip.close();
        return out.toByteArray();
    }

    public static class ProcessHelper {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getProcessName() {
            File f = new File("/proc/self/cmdline");
            FileInputStream reader = null;
            try {
                reader = new FileInputStream(f);
                byte[] buffer = new byte[256];
                int length = ((InputStream)reader).read(buffer);
                if (length > 0) {
                    String string = new String(buffer, 0, length).trim();
                    return string;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        ((InputStream)reader).close();
                    }
                    catch (IOException e) {}
                }
            }
            return "";
        }
    }
}

