/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.utils;

import android.content.Context;
import android.text.TextUtils;
import com.ainirobot.base.AnalyticsApplicationWrapper;
import com.ainirobot.base.analytics.interfaces.IAnalyticsConfig;
import com.ainirobot.base.util.CommonUtils;
import com.ainirobot.base.util.LocalUtils;
import com.ainirobot.base.util.Logger;
import com.ainirobot.base.util.SystemUtils;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicDataUtils {
    private static JSONObject sPublicDataJson;
    private static String mNetworkType;
    private static String mPlatform;
    private static String mCharacter;
    private static String mOSType;
    private static String mRnVersion;
    private static String mOSLan;
    private static String mLan;

    public static void preparePublicData(Context context, IAnalyticsConfig config) {
        sPublicDataJson = new JSONObject();
        try {
            if (config != null) {
                config.addPublicData(sPublicDataJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized JSONObject getPublicDataJson() {
        if (sPublicDataJson == null && Logger.debuggable()) {
            throw new RuntimeException("Run preparePublicData firstly!!");
        }
        try {
            if (sPublicDataJson != null) {
                sPublicDataJson.put("os_type", (Object)PublicDataUtils.getOSType());
                sPublicDataJson.put("brand", (Object)SystemUtils.getSystemBrand());
                sPublicDataJson.put("model", (Object)SystemUtils.getSystemModel());
                sPublicDataJson.put("rdid", (Object)SystemUtils.getSystemSerialNo());
                sPublicDataJson.put("ruid", (Object)LocalUtils.getRobotUUID(AnalyticsApplicationWrapper.getApplicationContext()));
                sPublicDataJson.put("corpid", (Object)LocalUtils.getVoiceCorpId(AnalyticsApplicationWrapper.getApplicationContext()));
                sPublicDataJson.put("version", (Object)SystemUtils.getSystemVersion());
                sPublicDataJson.put("send_time", (Object)String.valueOf(System.currentTimeMillis()));
                sPublicDataJson.put("network", (Object)PublicDataUtils.getNetworkType());
                sPublicDataJson.put("platform", (Object)PublicDataUtils.getPlatform());
                sPublicDataJson.put("rn_version", (Object)PublicDataUtils.getRnVersion());
                sPublicDataJson.put("character", (Object)PublicDataUtils.getCharacter());
                sPublicDataJson.put("os_lan", (Object)PublicDataUtils.getOSLan());
                sPublicDataJson.put("lan", (Object)PublicDataUtils.getLan());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sPublicDataJson;
    }

    public static synchronized void addPublicDataJson(JSONObject jsonObject) {
        if (sPublicDataJson == null && Logger.debuggable()) {
            throw new RuntimeException("Run preparePublicData firstly!!");
        }
        if (jsonObject == null) {
            return;
        }
        Iterator iterator = jsonObject.keys();
        while (iterator != null && iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                if (sPublicDataJson == null) continue;
                sPublicDataJson.put(key, jsonObject.get(key));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setNetworkType(String networkType) {
        mNetworkType = networkType;
    }

    public static String getNetworkType() {
        if (TextUtils.isEmpty((CharSequence)mNetworkType)) {
            return String.valueOf(CommonUtils.getNetworkState(AnalyticsApplicationWrapper.getApplicationContext()));
        }
        return mNetworkType;
    }

    public static void setPlatform(String platform) {
        mPlatform = platform;
    }

    public static String getPlatform() {
        if (TextUtils.isEmpty((CharSequence)mPlatform)) {
            return "";
        }
        return mPlatform;
    }

    public static void setCharacter(String character) {
        mCharacter = character;
    }

    public static String getCharacter() {
        if (TextUtils.isEmpty((CharSequence)mCharacter)) {
            return "";
        }
        return mCharacter;
    }

    public static void setOSType(String osType) {
        mOSType = osType;
    }

    public static String getOSType() {
        if (TextUtils.isEmpty((CharSequence)mOSType)) {
            return "";
        }
        return mOSType;
    }

    public static void setRnVersion(String rnVersion) {
        mRnVersion = rnVersion;
    }

    public static String getRnVersion() {
        if (TextUtils.isEmpty((CharSequence)mRnVersion)) {
            return "";
        }
        return mRnVersion;
    }

    public static void setOSLan(String osLan) {
        mOSLan = osLan;
    }

    public static String getOSLan() {
        if (TextUtils.isEmpty((CharSequence)mOSLan)) {
            return "";
        }
        return mOSLan;
    }

    public static void setLan(String lan) {
        mLan = lan;
    }

    public static String getLan() {
        if (TextUtils.isEmpty((CharSequence)mLan)) {
            return "";
        }
        return mLan;
    }
}

