/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.ainirobot.base.analytics.utils.KFileUtil;
import java.io.File;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KSupportUtil {
    public static final String LOG_TAG = "KSupport";
    public static final String FILE_EXT = ".ich";
    public static final char SEP_CHAR = '_';

    public static File getExisted_CACHE_DIR(Context context, String cacheDirectoryName) {
        File dir = KSupportUtil.get_CACHE_DIR(context, cacheDirectoryName);
        return KSupportUtil.getExistsDir(dir);
    }

    public static File get_CACHE_DIR(Context context, String cacheDirectoryName) {
        if (context == null) {
            return null;
        }
        File dir = context.getFilesDir();
        return dir == null ? null : new File(dir, cacheDirectoryName);
    }

    public static File getExistsDir(File dir) {
        if (dir == null) {
            return null;
        }
        if (dir.isDirectory() && dir.exists()) {
            return dir;
        }
        return null;
    }

    public static boolean isNetworkActive(Context context) {
        if (context == null) {
            return false;
        }
        boolean bReturn = false;
        try {
            ConnectivityManager conManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = conManager.getActiveNetworkInfo();
            if (netInfo != null && netInfo.isConnected()) {
                bReturn = true;
                return bReturn;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bReturn;
    }

    public static long getDayDiff(long dateCache) {
        long dateNow = System.currentTimeMillis();
        long diff = (long)((double)((dateNow - dateCache) / 86400000L) + 0.5);
        return diff;
    }

    public static void CheckMoreCrashInfo() {
    }

    public static int getIchCount_CACHE_DIR(Context context, int prioriry, String cacheDirectoryName) {
        File dirIch = KSupportUtil.getExisted_CACHE_DIR(context, cacheDirectoryName);
        return dirIch != null ? KFileUtil.pathFileCount(dirIch.getAbsolutePath()) : 0;
    }

    public static File getExistOrCreate_CACHE_DIR(Context context, String cacheDirectoryName) {
        File d = KSupportUtil.get_CACHE_DIR(context, cacheDirectoryName);
        if (d == null) {
            return null;
        }
        if (d.exists()) {
            if (d.isFile()) {
                d.delete();
                d.mkdir();
            }
        } else {
            d.mkdir();
        }
        return d.exists() ? d : null;
    }

    @SuppressLint(value={"SdCardPath"})
    public static File getFilesDir(Context ctx) {
        if (null == ctx) {
            return null;
        }
        File result = null;
        for (int i = 0; i < 3 && null == (result = ctx.getFilesDir()); ++i) {
            try {
                Thread.sleep(166L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new File("/data/data/" + ctx.getPackageName() + "/files/");
        }
        return result;
    }

    public static class AESCoder {
        private static final String KEY_ALGORITHM = "AES";
        private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

        private static Key toKey(byte[] key) {
            return new SecretKeySpec(key, KEY_ALGORITHM);
        }

        public static byte[] encrypt(byte[] data, Key key) throws Exception {
            return AESCoder.encrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
        }

        public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
            return AESCoder.encrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
        }

        public static byte[] encrypt(byte[] data, byte[] key, String cipherAlgorithm) throws Exception {
            Key k = AESCoder.toKey(key);
            return AESCoder.encrypt(data, k, cipherAlgorithm);
        }

        @SuppressLint(value={"TrulyRandom"})
        public static byte[] encrypt(byte[] data, Key key, String cipherAlgorithm) throws Exception {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(1, key);
            return cipher.doFinal(data);
        }

        public static byte[] encrypt(byte[] data, byte[] key, byte[] ivBytes, String cipherAlgorithm) throws Exception {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            Key keySpec = AESCoder.toKey(key);
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            cipher.init(1, keySpec, ivSpec);
            return cipher.doFinal(data);
        }

        public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
            return AESCoder.decrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
        }

        public static byte[] decrypt(byte[] data, Key key) throws Exception {
            return AESCoder.decrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
        }

        public static byte[] decrypt(byte[] data, byte[] key, String cipherAlgorithm) throws Exception {
            Key k = AESCoder.toKey(key);
            return AESCoder.decrypt(data, k, cipherAlgorithm);
        }

        public static byte[] decrypt(byte[] data, byte[] key, byte[] ivBytes, String cipherAlgorithm) throws Exception {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            Key keySpec = AESCoder.toKey(key);
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            cipher.init(2, keySpec, ivSpec);
            return cipher.doFinal(data);
        }

        public static byte[] decrypt(byte[] data, Key key, String cipherAlgorithm) throws Exception {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(2, key);
            return cipher.doFinal(data);
        }

        @SuppressLint(value={"DefaultLocale"})
        public static String parseByte2HexStr(byte[] buf) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < buf.length; ++i) {
                String hex = Integer.toHexString(buf[i] & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex.toUpperCase());
            }
            return sb.toString();
        }
    }
}

