/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.ainirobot.base.analytics.utils.KSupportUtil;
import com.ainirobot.base.analytics.utils.Md5Util;
import com.ainirobot.base.util.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class KFileUtil {
    public static File createFile(String filePath) throws IOException {
        File file = new File(filePath);
        file.createNewFile();
        return file;
    }

    public static File createDir(String dirPath) {
        File dir = new File(dirPath);
        dir.mkdir();
        return dir;
    }

    public static boolean isFileExist(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean deleteFile(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return true;
        }
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            boolean isDelete = file.delete();
            if (Logger.debuggable() && isDelete) {
                Logger.d("OBAnalytics", "delete file name =   " + fileName);
            }
            return true;
        }
        return false;
    }

    public static void delFolder(String folderPath) {
        try {
            KFileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean delAllFile(String path) {
        if (path == null || path.length() <= 0) {
            return false;
        }
        boolean bReturn = false;
        File file = new File(path);
        if (!file.exists()) {
            return bReturn;
        }
        if (!file.isDirectory()) {
            return bReturn;
        }
        String[] tempList = file.list();
        if (tempList != null) {
            File temp = null;
            for (int i = 0; i < tempList.length; ++i) {
                temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
                if (temp.isFile()) {
                    temp.delete();
                }
                if (!temp.isDirectory()) continue;
                KFileUtil.delAllFile(path + File.separatorChar + tempList[i]);
                KFileUtil.delFolder(path + File.separatorChar + tempList[i]);
                bReturn = true;
            }
        }
        return bReturn;
    }

    public static int pathFileCount(String path) {
        if (null == path || path.length() <= 0) {
            return 0;
        }
        File pathFile = new File(path);
        if (!pathFile.exists() || !pathFile.isDirectory()) {
            return 0;
        }
        String[] pathFileNames = pathFile.list();
        if (null == pathFileNames) {
            return 0;
        }
        return pathFileNames.length;
    }

    public static int getDirFileCount(File dir) {
        int fileCount = 0;
        File[] list = dir.listFiles();
        if (null == list) {
            return fileCount;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isFile()) continue;
            ++fileCount;
        }
        return fileCount;
    }

    public static int getDirAllFileCount(File dir) {
        int fileCount = 0;
        File[] list = dir.listFiles();
        if (null == list) {
            return 0;
        }
        for (File file : list) {
            if (file.isFile()) {
                ++fileCount;
                continue;
            }
            if (!file.isDirectory()) continue;
            fileCount += KFileUtil.getDirAllFileCount(file);
        }
        return fileCount;
    }

    public static boolean isCacheDirAvail(Context context) {
        if (null == context) {
            return false;
        }
        return null != context.getCacheDir();
    }

    public static void copyAssetFileToFiles(Context context, String assetfilename, String dstRelativePath) throws IOException {
        KFileUtil.getAssertFile(context, assetfilename, KSupportUtil.getFilesDir(context) + "/" + dstRelativePath);
    }

    public static boolean getAssertFile(Context context, String srcPath, String fileName) {
        if (context == null || fileName == null || srcPath == null) {
            return false;
        }
        boolean bReturn = false;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            AssetManager assertManager = context.getAssets();
            File file = new File(fileName);
            if (file != null && file.exists()) {
                if (file.isFile()) {
                    String destMD5 = Md5Util.getFileMD5(file);
                    InputStream in = null;
                    try {
                        in = assertManager.open(srcPath);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String srcMD5 = Md5Util.getStreamMD5(in);
                    if (destMD5.equals(srcMD5)) {
                        if (null != in) {
                            in.close();
                        }
                        return true;
                    }
                    if (null != in) {
                        in.close();
                    }
                    file.delete();
                } else {
                    KFileUtil.delFolder(fileName);
                }
            }
            try {
                is = assertManager.open(srcPath);
                os = new FileOutputStream(fileName);
            }
            catch (IOException destMD5) {
                // empty catch block
            }
            int BUF_SIZE = 4096;
            byte[] buffer = new byte[4096];
            int bytes = 0;
            while ((bytes = is.read(buffer)) > 0) {
                os.write(buffer, 0, bytes);
            }
            buffer = null;
            is.close();
            os.flush();
            os.close();
            os = null;
            bReturn = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bReturn;
    }
}

