/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;

public class KFile {
    public static final int MAX_FILE_LEN = 1024;

    public boolean saveCacheFile(String dirName, String fileName, byte[] content) throws IOException {
        boolean bReturn = false;
        File file = new File(dirName + File.separator + fileName);
        FileOutputStream outStream = new FileOutputStream(file);
        FileLock fl = outStream.getChannel().tryLock();
        if (fl != null) {
            outStream.write(content);
            outStream.getFD().sync();
            fl.release();
            bReturn = true;
        }
        outStream.close();
        return bReturn;
    }

    public static byte[] readBuffer(File file) throws IOException {
        byte[] byteReturn = null;
        FileInputStream fis = new FileInputStream(file);
        int len = fis.available();
        if (len > 1024) {
            len = 1024;
        }
        if (len <= 0) {
            fis.close();
            return null;
        }
        byte[] b = new byte[len];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (fis.read(b) != -1) {
            byteArrayOutputStream.write(b);
        }
        fis.close();
        byteReturn = byteArrayOutputStream.toByteArray();
        return byteReturn;
    }
}

