/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.utils;

import com.ainirobot.base.analytics.utils.AesWrapper;
import com.ainirobot.base.analytics.utils.StringUtil;
import com.ainirobot.base.network.HttpMethod;
import com.ainirobot.base.network.HttpRequest;
import com.ainirobot.base.network.HttpRequestFactory;
import com.ainirobot.base.report.AbstractSpiCall;
import com.ainirobot.base.util.Logger;
import org.json.JSONObject;

public final class AnalyticsSpiCall
extends AbstractSpiCall {
    private final AesWrapper mAes = new AesWrapper();

    public AnalyticsSpiCall(String url, HttpRequestFactory requestFactory) {
        super(url, requestFactory, HttpMethod.POST);
    }

    public JSONObject invoke(String requestData) throws Exception {
        HttpRequest httpRequest = this.applyHeadersTo(this.getHttpRequest());
        httpRequest.readTimeout(60000).connectTimeout(60000);
        httpRequest = this.applyMultipartDataTo(httpRequest, requestData);
        JSONObject toReturn = this.handleResponse(httpRequest);
        return toReturn;
    }

    private HttpRequest applyHeadersTo(HttpRequest request) {
        this.applyNonNullHeader(request, "Accept", "application/json");
        return request;
    }

    private void applyNonNullHeader(HttpRequest request, String key, String value) {
        if (value != null) {
            request.header(key, value);
        }
    }

    private HttpRequest applyMultipartDataTo(HttpRequest request, String queryParams) {
        try {
            request.send(this.mAes.encode(StringUtil.compress(queryParams.getBytes())));
            return request;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject handleResponse(HttpRequest httpRequest) throws Exception {
        int statusCode = httpRequest.code();
        if (!this.requestWasSuccessful(statusCode)) {
            if (Logger.debuggable()) {
                Logger.d("OBAnalytics", "Failed to retrieve settings from " + this.getUrl());
            }
            throw new RuntimeException("HttpRequest error = " + statusCode);
        }
        JSONObject toReturn = this.getJsonObjectFrom(httpRequest.body());
        return toReturn;
    }

    private boolean requestWasSuccessful(int httpStatusCode) {
        if (Logger.debuggable()) {
            Logger.d("OBAnalytics", "httpStatusCode = " + httpStatusCode);
        }
        return httpStatusCode == 200 || httpStatusCode == 201 || httpStatusCode == 202 || httpStatusCode == 203;
    }

    private JSONObject getJsonObjectFrom(String httpRequestBody) throws Exception {
        return new JSONObject(httpRequestBody);
    }
}

