/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.model;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.analytics.model.Event;
import com.ainirobot.base.analytics.model.FileData;
import com.ainirobot.base.analytics.model.KSupportEnv;
import com.ainirobot.base.analytics.utils.AesWrapper;
import com.ainirobot.base.analytics.utils.KFile;
import com.ainirobot.base.analytics.utils.KFileUtil;
import com.ainirobot.base.analytics.utils.KSupportUtil;
import com.ainirobot.base.analytics.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class FileDataManager {
    private final AesWrapper mAES;
    private KSupportEnv mEnv = new KSupportEnv();
    private Context mContext;
    private static Pattern ICH_FILE_PATTERN = Pattern.compile(".*_(\\d+).ich");
    public static Comparator<CacheFile> CacheFileComparator = new Comparator<CacheFile>(){

        @Override
        public int compare(CacheFile c1, CacheFile c2) {
            return (int)(c1.getCreateTime() - c2.getCreateTime());
        }
    };

    public FileDataManager(Context context) {
        this.mContext = context;
        this.mAES = new AesWrapper();
    }

    public boolean saveCache(Event event) {
        String content = event.getContent();
        if (TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        return this.saveCache(content.getBytes(), event.getTableName());
    }

    private boolean saveCache(byte[] data, String tableName) {
        boolean bReturn = false;
        if (data == null) {
            return bReturn;
        }
        File dIch = KSupportUtil.getExistOrCreate_CACHE_DIR(this.mContext, this.mEnv.getEnv().getCacheDirectoryName());
        if (dIch == null) {
            return bReturn;
        }
        int size = data.length;
        if (size <= 0) {
            return bReturn;
        }
        try {
            KFile file = new KFile();
            String filePath = this.getCacheFileName(tableName);
            StringBuffer buffer = new StringBuffer();
            buffer.append(filePath).append('_').append(UUID.randomUUID().toString()).append('_').append(System.currentTimeMillis()).append(".ich");
            bReturn = file.saveCacheFile(dIch.getAbsolutePath(), buffer.toString(), this.mAES.encode(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bReturn;
    }

    public int size() {
        File ichd = KSupportUtil.getExisted_CACHE_DIR(this.mContext, this.mEnv.getEnv().getCacheDirectoryName());
        if (ichd == null) {
            return 0;
        }
        File[] ichs = ichd.listFiles();
        if (ichs == null || ichs.length == 0) {
            return 0;
        }
        return ichs.length;
    }

    public void delete() {
        File ichd = KSupportUtil.getExisted_CACHE_DIR(this.mContext, this.mEnv.getEnv().getCacheDirectoryName());
        if (ichd == null) {
            return;
        }
        KFileUtil.delFolder(ichd.getPath());
    }

    public void delete(List<String> fileNames) {
        if (fileNames != null && fileNames.size() > 0) {
            for (String fileName : fileNames) {
                KFileUtil.deleteFile(fileName);
            }
        }
    }

    private String getCacheFileName(String tableName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(tableName).append('_').append(StringUtil.ProcessHelper.getProcessName());
        return buffer.toString();
    }

    void removeOvermuchCache() {
        CacheFile f;
        File ichd = KSupportUtil.getExisted_CACHE_DIR(this.mContext, this.mEnv.getEnv().getCacheDirectoryName());
        if (ichd == null) {
            return;
        }
        File[] ichs = ichd.listFiles();
        if (ichs == null || ichs.length < this.mEnv.getEnv().getMaxCacheCount()) {
            return;
        }
        PriorityQueue<CacheFile> customerPriorityQueue = new PriorityQueue<CacheFile>(this.mEnv.getEnv().getMaxCacheCount(), CacheFileComparator);
        for (File ich : ichs) {
            if (!ich.isFile()) continue;
            customerPriorityQueue.add(new CacheFile(FileDataManager.getCreateTime(ich.getName()), ich));
        }
        for (int i = this.mEnv.getEnv().getDeleteCacheNum(); i > 0 && (f = (CacheFile)customerPriorityQueue.poll()) != null; --i) {
            File file = f.getFile();
            file.delete();
            Log.i((String)"OBAnalytics", (String)("clear over much log file = " + file.getName()));
        }
    }

    public static long getCreateTime(String name) {
        long timestamp = 0L;
        try {
            Matcher m = ICH_FILE_PATTERN.matcher(name);
            if (m.matches()) {
                timestamp = Long.parseLong(m.group(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            timestamp = 0L;
        }
        return timestamp;
    }

    public FileData getCountFile(int count) {
        FileData fileData = new FileData();
        ArrayList<JSONObject> allData = new ArrayList<JSONObject>();
        ArrayList<String> fileNames = new ArrayList<String>();
        if (count <= 0) {
            return fileData;
        }
        try {
            File ichd = KSupportUtil.getExisted_CACHE_DIR(this.mContext, this.mEnv.getEnv().getCacheDirectoryName());
            if (ichd == null) {
                return fileData;
            }
            File[] ichs = ichd.listFiles();
            if (ichs == null || ichs.length == 0) {
                return fileData;
            }
            int deleteCount = ichs.length < count ? ichs.length : count;
            for (int i = 0; i < deleteCount; ++i) {
                byte[] bytes = KFile.readBuffer(ichs[i]);
                String fileName = ichs[i].getAbsolutePath();
                fileNames.add(fileName);
                if (bytes != null) {
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject = new JSONObject(new String(this.mAES.decode(bytes)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jsonObject.length() != 0) {
                        allData.add(jsonObject);
                    }
                    bytes = null;
                    continue;
                }
                Log.e((String)"OBAnalytics", (String)("file is null, file name = " + fileName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fileData.fileJSON = allData;
        fileData.fileNames = fileNames;
        return fileData;
    }

    public List<JSONObject> getAll() {
        ArrayList<JSONObject> allData = new ArrayList<JSONObject>();
        try {
            int i = 0;
            File ichd = KSupportUtil.getExisted_CACHE_DIR(this.mContext, this.mEnv.getEnv().getCacheDirectoryName());
            if (ichd == null) {
                return allData;
            }
            File[] ichs = ichd.listFiles();
            if (ichs == null || ichs.length == 0) {
                return allData;
            }
            for (File file : ichs) {
                byte[] bytes = KFile.readBuffer(file);
                if (bytes != null) {
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject = new JSONObject(new String(this.mAES.decode(bytes)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    allData.add(jsonObject);
                    continue;
                }
                Log.e((String)"OBAnalytics", (String)("file is null, file name = " + file.getName()));
            }
            ++i;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allData;
    }

    public class CacheFile {
        private long createTime;
        private File ichd;

        public CacheFile(long t, File f) {
            this.createTime = t;
            this.ichd = f;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public File getFile() {
            return this.ichd;
        }
    }
}

