/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.base.analytics.model;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.AnalyticsApplicationWrapper;
import com.ainirobot.base.util.CommonUtils;
import com.ainirobot.base.util.Logger;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class Event {
    private final boolean mForceReport;
    private final long mEventTime;
    private final String mTableName;
    private final Bundle mBundle;
    private final int mNetWork;
    private String mJsonString;

    private Event(Builder builder) {
        this.mForceReport = builder.mIsForceReport;
        this.mTableName = builder.mTableName;
        this.mEventTime = System.currentTimeMillis();
        this.mNetWork = CommonUtils.getNetworkState(AnalyticsApplicationWrapper.getApplicationContext());
        if (builder.mBundle != null && TextUtils.isEmpty((CharSequence)builder.mDataString)) {
            this.mBundle = builder.mBundle;
            this.toJson();
        } else {
            this.mBundle = null;
            String dataString = builder.mDataString;
            JSONObject jsonObject = new JSONObject();
            try {
                String[] list;
                for (String string : list = dataString.split("&")) {
                    String[] strings = string.split("=");
                    if (strings.length >= 2) {
                        jsonObject.put(strings[0], (Object)string.substring(string.indexOf("=") + 1));
                        continue;
                    }
                    if (strings.length != 1) continue;
                    jsonObject.put(strings[0], (Object)"");
                }
                jsonObject.put("table_name", (Object)this.mTableName);
                this.mJsonString = jsonObject.toString();
            }
            catch (Exception e) {
                this.mJsonString = null;
                Log.e((String)"OBAnalytics", (String)("ERROR FORMATTED: table:" + this.mTableName + ", data:" + dataString));
            }
        }
    }

    public boolean isForceReport() {
        return this.mForceReport;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public String getContent() {
        if (TextUtils.isEmpty((CharSequence)this.mJsonString)) {
            this.toJson();
        }
        return this.mJsonString;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public synchronized boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.mJsonString) && (this.mBundle == null || this.mBundle.isEmpty());
    }

    private synchronized void toJson() {
        if (this.isEmpty()) {
            return;
        }
        JSONObject json = new JSONObject();
        try {
            json.put("table_name", (Object)this.mTableName);
            Bundle bundle = this.mBundle;
            Set keys = bundle.keySet();
            for (String key : keys) {
                json.put(key, JSONObject.wrap((Object)bundle.get(key)));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.mJsonString = json.toString();
    }

    public static class Builder {
        private boolean mIsForceReport;
        private String mTableName;
        private String mDataString;
        private Bundle mBundle = new Bundle();

        public Builder tableName(String tableName) {
            this.mTableName = tableName;
            return this;
        }

        public Builder dataString(String dataString) {
            this.mDataString = dataString;
            return this;
        }

        public Builder bundle(Bundle bundle) {
            this.mBundle = bundle;
            return this;
        }

        public Builder forceReport(boolean isForceReport) {
            this.mIsForceReport = isForceReport;
            return this;
        }

        public Event create() {
            if (TextUtils.isEmpty((CharSequence)this.mTableName) && Logger.debuggable()) {
                throw new RuntimeException("The table name is empty!");
            }
            if (TextUtils.isEmpty((CharSequence)this.mDataString) && this.mBundle.isEmpty() && Logger.debuggable()) {
                throw new RuntimeException("Not add any filed!");
            }
            return new Event(this);
        }
    }
}

